; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -verify-machineinstrs -amdgpu-enable-delay-alu=0 < %s | FileCheck %s -check-prefixes=GCN,GFX11
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -verify-machineinstrs -amdgpu-enable-delay-alu=0 -enable-no-nans-fp-math < %s | FileCheck %s -check-prefixes=GCN,GFX11NONANS

; The tests check the following optimization of DAGCombiner:
; CMP(A,C)||CMP(B,C) => CMP(MIN/MAX(A,B), C)
; CMP(A,C)&&CMP(B,C) => CMP(MIN/MAX(A,B), C)

define i1 @test1(i32 %arg1, i32 %arg2) {
; GCN-LABEL: test1:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_min_i32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_gt_i32_e32 vcc_lo, 0x3e8, v0
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp slt i32 %arg1, 1000
  %cmp2 = icmp slt i32 %arg2, 1000
  %or  = or i1 %cmp1, %cmp2
  ret i1 %or
}

define i1 @test2(i32 %arg1, i32 %arg2) {
; GCN-LABEL: test2:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_min_u32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_gt_u32_e32 vcc_lo, 0x3e8, v0
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp ult i32 %arg1, 1000
  %cmp2 = icmp ult i32 %arg2, 1000
  %or = or i1 %cmp1, %cmp2
  ret i1 %or
}

define i1 @test3(i32 %arg1, i32 %arg2) {
; GCN-LABEL: test3:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_min_i32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_gt_i32_e32 vcc_lo, 0x3e9, v0
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp sle i32 %arg1, 1000
  %cmp2 = icmp sle i32 %arg2, 1000
  %or = or i1 %cmp1, %cmp2
  ret i1 %or
}

define i1 @test4(i32 %arg1, i32 %arg2) {
; GCN-LABEL: test4:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_min_u32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_gt_u32_e32 vcc_lo, 0x3e9, v0
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp ule i32 %arg1, 1000
  %cmp2 = icmp ule i32 %arg2, 1000
  %or = or i1 %cmp1, %cmp2
  ret i1 %or
}

define i1 @test5(i32 %arg1, i32 %arg2) {
; GCN-LABEL: test5:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_max_i32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_lt_i32_e32 vcc_lo, 0x3e8, v0
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp sgt i32 %arg1, 1000
  %cmp2 = icmp sgt i32 %arg2, 1000
  %or = or i1 %cmp1, %cmp2
  ret i1 %or
}

define i1 @test6(i32 %arg1, i32 %arg2) {
; GCN-LABEL: test6:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_max_u32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_lt_u32_e32 vcc_lo, 0x3e8, v0
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp ugt i32 %arg1, 1000
  %cmp2 = icmp ugt i32 %arg2, 1000
  %or = or i1 %cmp1, %cmp2
  ret i1 %or
}

define i1 @test7(i32 %arg1, i32 %arg2) {
; GCN-LABEL: test7:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_max_i32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_lt_i32_e32 vcc_lo, 0x3e7, v0
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp sge i32 %arg1, 1000
  %cmp2 = icmp sge i32 %arg2, 1000
  %or = or i1 %cmp1, %cmp2
  ret i1 %or
}

define i1 @test8(i32 %arg1, i32 %arg2) {
; GCN-LABEL: test8:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_max_u32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_lt_u32_e32 vcc_lo, 0x3e7, v0
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp uge i32 %arg1, 1000
  %cmp2 = icmp uge i32 %arg2, 1000
  %or = or i1 %cmp1, %cmp2
  ret i1 %or
}

define i1 @test9(i32 %arg1, i32 %arg2, i32 %arg3) {
; GCN-LABEL: test9:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_min_i32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_lt_i32_e32 vcc_lo, v0, v2
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp slt i32 %arg1, %arg3
  %cmp2 = icmp slt i32 %arg2, %arg3
  %or = or i1 %cmp1, %cmp2
  ret i1 %or
}

define i1 @test10(i32 %arg1, i32 %arg2, i32 %arg3) {
; GCN-LABEL: test10:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_min_u32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_lt_u32_e32 vcc_lo, v0, v2
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp ult i32 %arg1, %arg3
  %cmp2 = icmp ult i32 %arg2, %arg3
  %or = or i1 %cmp1, %cmp2
  ret i1 %or
}

define i1 @test11(i32 %arg1, i32 %arg2, i32 %arg3) {
; GCN-LABEL: test11:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_min_i32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_le_i32_e32 vcc_lo, v0, v2
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp sle i32 %arg1, %arg3
  %cmp2 = icmp sle i32 %arg2, %arg3
  %or = or i1 %cmp1, %cmp2
  ret i1 %or
}

define i1 @test12(i32 %arg1, i32 %arg2, i32 %arg3) {
; GCN-LABEL: test12:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_min_u32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_le_u32_e32 vcc_lo, v0, v2
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp ule i32 %arg1, %arg3
  %cmp2 = icmp ule i32 %arg2, %arg3
  %or = or i1 %cmp1, %cmp2
  ret i1 %or
}

define i1 @test13(i32 %arg1, i32 %arg2, i32 %arg3) {
; GCN-LABEL: test13:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_max_i32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_gt_i32_e32 vcc_lo, v0, v2
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp sgt i32 %arg1, %arg3
  %cmp2 = icmp sgt i32 %arg2, %arg3
  %or = or i1 %cmp1, %cmp2
  ret i1 %or
}

define i1 @test14(i32 %arg1, i32 %arg2, i32 %arg3) {
; GCN-LABEL: test14:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_max_u32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_gt_u32_e32 vcc_lo, v0, v2
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp ugt i32 %arg1, %arg3
  %cmp2 = icmp ugt i32 %arg2, %arg3
  %or = or i1 %cmp1, %cmp2
  ret i1 %or
}

define i1 @test15(i32 %arg1, i32 %arg2, i32 %arg3) {
; GCN-LABEL: test15:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_max_i32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_ge_i32_e32 vcc_lo, v0, v2
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp sge i32 %arg1, %arg3
  %cmp2 = icmp sge i32 %arg2, %arg3
  %or = or i1 %cmp1, %cmp2
  ret i1 %or
}

define i1 @test16(i32 %arg1, i32 %arg2, i32 %arg3) {
; GCN-LABEL: test16:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_max_u32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_ge_u32_e32 vcc_lo, v0, v2
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp uge i32 %arg1, %arg3
  %cmp2 = icmp uge i32 %arg2, %arg3
  %or = or i1 %cmp1, %cmp2
  ret i1 %or
}

define i1 @test17(i32 %arg1, i32 %arg2) {
; GCN-LABEL: test17:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_max_i32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_gt_i32_e32 vcc_lo, 0x3e8, v0
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp slt i32 %arg1, 1000
  %cmp2 = icmp slt i32 %arg2, 1000
  %and  = and i1 %cmp1, %cmp2
  ret i1 %and
}

define i1 @test18(i32 %arg1, i32 %arg2) {
; GCN-LABEL: test18:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_max_u32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_gt_u32_e32 vcc_lo, 0x3e8, v0
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp ult i32 %arg1, 1000
  %cmp2 = icmp ult i32 %arg2, 1000
  %and = and i1 %cmp1, %cmp2
  ret i1 %and
}

define i1 @test19(i32 %arg1, i32 %arg2) {
; GCN-LABEL: test19:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_max_i32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_gt_i32_e32 vcc_lo, 0x3e9, v0
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp sle i32 %arg1, 1000
  %cmp2 = icmp sle i32 %arg2, 1000
  %and = and i1 %cmp1, %cmp2
  ret i1 %and
}

define i1 @test20(i32 %arg1, i32 %arg2) {
; GCN-LABEL: test20:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_max_u32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_gt_u32_e32 vcc_lo, 0x3e9, v0
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp ule i32 %arg1, 1000
  %cmp2 = icmp ule i32 %arg2, 1000
  %and = and i1 %cmp1, %cmp2
  ret i1 %and
}

define i1 @test21(i32 %arg1, i32 %arg2) {
; GCN-LABEL: test21:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_min_i32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_lt_i32_e32 vcc_lo, 0x3e8, v0
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp sgt i32 %arg1, 1000
  %cmp2 = icmp sgt i32 %arg2, 1000
  %and = and i1 %cmp1, %cmp2
  ret i1 %and
}

define i1 @test22(i32 %arg1, i32 %arg2) {
; GCN-LABEL: test22:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_min_u32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_lt_u32_e32 vcc_lo, 0x3e8, v0
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp ugt i32 %arg1, 1000
  %cmp2 = icmp ugt i32 %arg2, 1000
  %and = and i1 %cmp1, %cmp2
  ret i1 %and
}

define i1 @test23(i32 %arg1, i32 %arg2) {
; GCN-LABEL: test23:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_min_i32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_lt_i32_e32 vcc_lo, 0x3e7, v0
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp sge i32 %arg1, 1000
  %cmp2 = icmp sge i32 %arg2, 1000
  %and = and i1 %cmp1, %cmp2
  ret i1 %and
}

define i1 @test24(i32 %arg1, i32 %arg2) {
; GCN-LABEL: test24:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_min_u32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_lt_u32_e32 vcc_lo, 0x3e7, v0
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp uge i32 %arg1, 1000
  %cmp2 = icmp uge i32 %arg2, 1000
  %and = and i1 %cmp1, %cmp2
  ret i1 %and
}

define i1 @test25(i32 %arg1, i32 %arg2, i32 %arg3) {
; GCN-LABEL: test25:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_max_i32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_lt_i32_e32 vcc_lo, v0, v2
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp slt i32 %arg1, %arg3
  %cmp2 = icmp slt i32 %arg2, %arg3
  %and = and i1 %cmp1, %cmp2
  ret i1 %and
}

define i1 @test26(i32 %arg1, i32 %arg2, i32 %arg3) {
; GCN-LABEL: test26:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_max_u32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_lt_u32_e32 vcc_lo, v0, v2
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp ult i32 %arg1, %arg3
  %cmp2 = icmp ult i32 %arg2, %arg3
  %and = and i1 %cmp1, %cmp2
  ret i1 %and
}

define i1 @test27(i32 %arg1, i32 %arg2, i32 %arg3) {
; GCN-LABEL: test27:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_max_i32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_le_i32_e32 vcc_lo, v0, v2
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp sle i32 %arg1, %arg3
  %cmp2 = icmp sle i32 %arg2, %arg3
  %and = and i1 %cmp1, %cmp2
  ret i1 %and
}

define i1 @test28(i32 %arg1, i32 %arg2, i32 %arg3) {
; GCN-LABEL: test28:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_max_u32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_le_u32_e32 vcc_lo, v0, v2
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp ule i32 %arg1, %arg3
  %cmp2 = icmp ule i32 %arg2, %arg3
  %and = and i1 %cmp1, %cmp2
  ret i1 %and
}

define i1 @test29(i32 %arg1, i32 %arg2, i32 %arg3) {
; GCN-LABEL: test29:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_min_i32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_gt_i32_e32 vcc_lo, v0, v2
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp sgt i32 %arg1, %arg3
  %cmp2 = icmp sgt i32 %arg2, %arg3
  %and = and i1 %cmp1, %cmp2
  ret i1 %and
}

define i1 @test30(i32 %arg1, i32 %arg2, i32 %arg3) {
; GCN-LABEL: test30:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_min_u32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_gt_u32_e32 vcc_lo, v0, v2
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp ugt i32 %arg1, %arg3
  %cmp2 = icmp ugt i32 %arg2, %arg3
  %and = and i1 %cmp1, %cmp2
  ret i1 %and
}

define i1 @test31(i32 %arg1, i32 %arg2, i32 %arg3) {
; GCN-LABEL: test31:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_min_i32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_ge_i32_e32 vcc_lo, v0, v2
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp sge i32 %arg1, %arg3
  %cmp2 = icmp sge i32 %arg2, %arg3
  %and = and i1 %cmp1, %cmp2
  ret i1 %and
}

define i1 @test32(i32 %arg1, i32 %arg2, i32 %arg3) {
; GCN-LABEL: test32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_min_u32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_ge_u32_e32 vcc_lo, v0, v2
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp uge i32 %arg1, %arg3
  %cmp2 = icmp uge i32 %arg2, %arg3
  %and = and i1 %cmp1, %cmp2
  ret i1 %and
}

define i1 @test33(i32 %arg1, i32 %arg2) {
; GCN-LABEL: test33:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_max_i32_e32 v1, 0x3e8, v1
; GCN-NEXT:    v_cmp_gt_i32_e32 vcc_lo, v1, v0
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp slt i32 %arg1, %arg2
  %cmp2 = icmp slt i32 %arg1, 1000
  %or  = or i1 %cmp1, %cmp2
  ret i1 %or
}

define amdgpu_gfx void @test34(i32 inreg %arg1, i32 inreg %arg2) {
; GCN-LABEL: test34:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_min_i32 s0, s4, s5
; GCN-NEXT:    v_mov_b32_e32 v0, 0
; GCN-NEXT:    s_cmpk_lt_i32 s0, 0x3e9
; GCN-NEXT:    v_mov_b32_e32 v1, 0
; GCN-NEXT:    s_cselect_b32 s0, -1, 0
; GCN-NEXT:    v_cndmask_b32_e64 v2, 0, 1, s0
; GCN-NEXT:    global_store_b8 v[0:1], v2, off dlc
; GCN-NEXT:    s_waitcnt_vscnt null, 0x0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp sle i32 %arg1, 1000
  %cmp2 = icmp sle i32 %arg2, 1000
  %or = or i1 %cmp1, %cmp2
  store volatile i1 %or, ptr addrspace(1) null
  ret void
}

define amdgpu_gfx void @test35(i32 inreg %arg1, i32 inreg %arg2) {
; GCN-LABEL: test35:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_max_i32 s0, s4, s5
; GCN-NEXT:    v_mov_b32_e32 v0, 0
; GCN-NEXT:    s_cmpk_gt_i32 s0, 0x3e8
; GCN-NEXT:    v_mov_b32_e32 v1, 0
; GCN-NEXT:    s_cselect_b32 s0, -1, 0
; GCN-NEXT:    v_cndmask_b32_e64 v2, 0, 1, s0
; GCN-NEXT:    global_store_b8 v[0:1], v2, off dlc
; GCN-NEXT:    s_waitcnt_vscnt null, 0x0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp sgt i32 %arg1, 1000
  %cmp2 = icmp sgt i32 %arg2, 1000
  %or = or i1 %cmp1, %cmp2
  store volatile i1 %or, ptr addrspace(1) null
  ret void
}

define amdgpu_gfx void @test36(i32 inreg %arg1, i32 inreg %arg2, i32 inreg %arg3) {
; GCN-LABEL: test36:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_min_u32 s0, s4, s5
; GCN-NEXT:    v_mov_b32_e32 v0, 0
; GCN-NEXT:    s_cmp_lt_u32 s0, s6
; GCN-NEXT:    v_mov_b32_e32 v1, 0
; GCN-NEXT:    s_cselect_b32 s0, -1, 0
; GCN-NEXT:    v_cndmask_b32_e64 v2, 0, 1, s0
; GCN-NEXT:    global_store_b8 v[0:1], v2, off dlc
; GCN-NEXT:    s_waitcnt_vscnt null, 0x0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp ult i32 %arg1, %arg3
  %cmp2 = icmp ult i32 %arg2, %arg3
  %or = or i1 %cmp1, %cmp2
  store volatile i1 %or, ptr addrspace(1) null
  ret void
}

define amdgpu_gfx void @test37(i32 inreg %arg1, i32 inreg %arg2, i32 inreg %arg3) {
; GCN-LABEL: test37:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_max_i32 s0, s4, s5
; GCN-NEXT:    v_mov_b32_e32 v0, 0
; GCN-NEXT:    s_cmp_ge_i32 s0, s6
; GCN-NEXT:    v_mov_b32_e32 v1, 0
; GCN-NEXT:    s_cselect_b32 s0, -1, 0
; GCN-NEXT:    v_cndmask_b32_e64 v2, 0, 1, s0
; GCN-NEXT:    global_store_b8 v[0:1], v2, off dlc
; GCN-NEXT:    s_waitcnt_vscnt null, 0x0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp sge i32 %arg1, %arg3
  %cmp2 = icmp sge i32 %arg2, %arg3
  %or = or i1 %cmp1, %cmp2
  store volatile i1 %or, ptr addrspace(1) null
  ret void
}

define amdgpu_gfx void @test38(i32 inreg %arg1, i32 inreg %arg2) {
; GCN-LABEL: test38:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_max_u32 s0, s4, s5
; GCN-NEXT:    v_mov_b32_e32 v0, 0
; GCN-NEXT:    s_cmpk_lt_u32 s0, 0x3e9
; GCN-NEXT:    v_mov_b32_e32 v1, 0
; GCN-NEXT:    s_cselect_b32 s0, -1, 0
; GCN-NEXT:    v_cndmask_b32_e64 v2, 0, 1, s0
; GCN-NEXT:    global_store_b8 v[0:1], v2, off dlc
; GCN-NEXT:    s_waitcnt_vscnt null, 0x0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp ule i32 %arg1, 1000
  %cmp2 = icmp ule i32 %arg2, 1000
  %and = and i1 %cmp1, %cmp2
  store volatile i1 %and, ptr addrspace(1) null
  ret void
}

define amdgpu_gfx void @test39(i32 inreg %arg1, i32 inreg %arg2) {
; GCN-LABEL: test39:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_min_i32 s0, s4, s5
; GCN-NEXT:    v_mov_b32_e32 v0, 0
; GCN-NEXT:    s_cmpk_gt_i32 s0, 0x3e7
; GCN-NEXT:    v_mov_b32_e32 v1, 0
; GCN-NEXT:    s_cselect_b32 s0, -1, 0
; GCN-NEXT:    v_cndmask_b32_e64 v2, 0, 1, s0
; GCN-NEXT:    global_store_b8 v[0:1], v2, off dlc
; GCN-NEXT:    s_waitcnt_vscnt null, 0x0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp sge i32 %arg1, 1000
  %cmp2 = icmp sge i32 %arg2, 1000
  %and = and i1 %cmp1, %cmp2
  store volatile i1 %and, ptr addrspace(1) null
  ret void
}

define amdgpu_gfx void @test40(i32 inreg %arg1, i32 inreg %arg2, i32 inreg %arg3) {
; GCN-LABEL: test40:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_max_i32 s0, s4, s5
; GCN-NEXT:    v_mov_b32_e32 v0, 0
; GCN-NEXT:    s_cmp_le_i32 s0, s6
; GCN-NEXT:    v_mov_b32_e32 v1, 0
; GCN-NEXT:    s_cselect_b32 s0, -1, 0
; GCN-NEXT:    v_cndmask_b32_e64 v2, 0, 1, s0
; GCN-NEXT:    global_store_b8 v[0:1], v2, off dlc
; GCN-NEXT:    s_waitcnt_vscnt null, 0x0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp sle i32 %arg1, %arg3
  %cmp2 = icmp sle i32 %arg2, %arg3
  %and = and i1 %cmp1, %cmp2
  store volatile i1 %and, ptr addrspace(1) null
  ret void
}

define amdgpu_gfx void @test41(i32 inreg %arg1, i32 inreg %arg2, i32 inreg %arg3) {
; GCN-LABEL: test41:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    s_min_u32 s0, s4, s5
; GCN-NEXT:    v_mov_b32_e32 v0, 0
; GCN-NEXT:    s_cmp_ge_u32 s0, s6
; GCN-NEXT:    v_mov_b32_e32 v1, 0
; GCN-NEXT:    s_cselect_b32 s0, -1, 0
; GCN-NEXT:    v_cndmask_b32_e64 v2, 0, 1, s0
; GCN-NEXT:    global_store_b8 v[0:1], v2, off dlc
; GCN-NEXT:    s_waitcnt_vscnt null, 0x0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp uge i32 %arg1, %arg3
  %cmp2 = icmp uge i32 %arg2, %arg3
  %and = and i1 %cmp1, %cmp2
  store volatile i1 %and, ptr addrspace(1) null
  ret void
}

define i1 @test42(i32 %arg1, i32 %arg2, i32 %arg3) {
; GCN-LABEL: test42:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_min_u32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_gt_u32_e32 vcc_lo, v0, v2
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp ult i32 %arg3, %arg1
  %cmp2 = icmp ult i32 %arg3, %arg2
  %or = and i1 %cmp1, %cmp2
  ret i1 %or
}

define i1 @test43(i32 %arg1, i32 %arg2, i32 %arg3) {
; GCN-LABEL: test43:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_max_u32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_gt_u32_e32 vcc_lo, v0, v2
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp ult i32 %arg3, %arg1
  %cmp2 = icmp ult i32 %arg3, %arg2
  %or = or i1 %cmp1, %cmp2
  ret i1 %or
}

define i1 @test44(i32 %arg1, i32 %arg2, i32 %arg3) {
; GCN-LABEL: test44:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_max_u32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_lt_u32_e32 vcc_lo, v0, v2
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp ugt i32 %arg3, %arg1
  %cmp2 = icmp ugt i32 %arg3, %arg2
  %or = and i1 %cmp1, %cmp2
  ret i1 %or
}

define i1 @test45(i32 %arg1, i32 %arg2, i32 %arg3) {
; GCN-LABEL: test45:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_min_u32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_lt_u32_e32 vcc_lo, v0, v2
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp ugt i32 %arg3, %arg1
  %cmp2 = icmp ugt i32 %arg3, %arg2
  %or = or i1 %cmp1, %cmp2
  ret i1 %or
}

define i1 @test46(i32 %arg1, i32 %arg2, i32 %arg3) {
; GCN-LABEL: test46:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_max_i32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_gt_i32_e32 vcc_lo, v0, v2
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp slt i32 %arg3, %arg1
  %cmp2 = icmp sgt i32 %arg2, %arg3
  %or  = or i1 %cmp1, %cmp2
  ret i1 %or
}

define i1 @test47(i32 %arg1, i32 %arg2, i32 %arg3) {
; GCN-LABEL: test47:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_max_i32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_gt_i32_e32 vcc_lo, v0, v2
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp sgt i32 %arg1, %arg3
  %cmp2 = icmp slt i32 %arg3, %arg2
  %or  = or i1 %cmp1, %cmp2
  ret i1 %or
}

define i1 @test48(i32 %arg1, i32 %arg2, i32 %arg3) {
; GCN-LABEL: test48:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_min_i32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_lt_i32_e32 vcc_lo, v0, v2
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp slt i32 %arg1, %arg3
  %cmp2 = icmp sgt i32 %arg3, %arg2
  %or  = or i1 %cmp1, %cmp2
  ret i1 %or
}

define i1 @test49(i32 %arg1, i32 %arg2, i32 %arg3) {
; GCN-LABEL: test49:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_min_i32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_lt_i32_e32 vcc_lo, v0, v2
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp sgt i32 %arg3, %arg1
  %cmp2 = icmp slt i32 %arg2, %arg3
  %or  = or i1 %cmp1, %cmp2
  ret i1 %or
}

define i1 @test50(i32 %arg1, i32 %arg2, i32 %arg3) {
; GCN-LABEL: test50:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_min_i32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_gt_i32_e32 vcc_lo, v0, v2
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp slt i32 %arg3, %arg1
  %cmp2 = icmp sgt i32 %arg2, %arg3
  %and  = and i1 %cmp1, %cmp2
  ret i1 %and
}

define i1 @test51(i32 %arg1, i32 %arg2, i32 %arg3) {
; GCN-LABEL: test51:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_min_i32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_gt_i32_e32 vcc_lo, v0, v2
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp sgt i32 %arg1, %arg3
  %cmp2 = icmp slt i32 %arg3, %arg2
  %and  = and i1 %cmp1, %cmp2
  ret i1 %and
}

define i1 @test52(i32 %arg1, i32 %arg2, i32 %arg3) {
; GCN-LABEL: test52:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_max_i32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_lt_i32_e32 vcc_lo, v0, v2
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp slt i32 %arg1, %arg3
  %cmp2 = icmp sgt i32 %arg3, %arg2
  %and  = and i1 %cmp1, %cmp2
  ret i1 %and
}

define i1 @test53(i32 %arg1, i32 %arg2, i32 %arg3) {
; GCN-LABEL: test53:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_max_i32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_lt_i32_e32 vcc_lo, v0, v2
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp sgt i32 %arg3, %arg1
  %cmp2 = icmp slt i32 %arg2, %arg3
  %and  = and i1 %cmp1, %cmp2
  ret i1 %and
}

define i1 @test54(float %arg1, float %arg2, float %arg3) #0 {
; GCN-LABEL: test54:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_min_f32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_lt_f32_e32 vcc_lo, v0, v2
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = fcmp olt float %arg1, %arg3
  %cmp2 = fcmp olt float %arg2, %arg3
  %or1  = or i1 %cmp1, %cmp2
  ret i1 %or1
}

define i1 @test55(double %arg1, double %arg2, double %arg3) #0 {
; GCN-LABEL: test55:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_min_f64 v[0:1], v[0:1], v[2:3]
; GCN-NEXT:    v_cmp_le_f64_e32 vcc_lo, v[0:1], v[4:5]
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = fcmp ole double %arg1, %arg3
  %cmp2 = fcmp ole double %arg2, %arg3
  %or1  = or i1 %cmp1, %cmp2
  ret i1 %or1
}

define i1 @test56(double %arg1, double %arg2, double %arg3) #0 {
; GCN-LABEL: test56:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_max_f64 v[0:1], v[0:1], v[2:3]
; GCN-NEXT:    v_cmp_gt_f64_e32 vcc_lo, v[0:1], v[4:5]
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = fcmp ogt double %arg1, %arg3
  %cmp2 = fcmp ogt double %arg2, %arg3
  %or1  = or i1 %cmp1, %cmp2
  ret i1 %or1
}

define i1 @test57(float %arg1, float %arg2, float %arg3) #0 {
; GCN-LABEL: test57:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_max_f32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_ge_f32_e32 vcc_lo, v0, v2
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = fcmp oge float %arg1, %arg3
  %cmp2 = fcmp oge float %arg2, %arg3
  %or1  = or i1 %cmp1, %cmp2
  ret i1 %or1
}

define i1 @test58(double %arg1, double %arg2, double %arg3) #0 {
; GFX11-LABEL: test58:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_min_f64 v[0:1], v[0:1], v[2:3]
; GFX11-NEXT:    v_cmp_nle_f64_e32 vcc_lo, v[0:1], v[4:5]
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test58:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_min_f64 v[0:1], v[0:1], v[2:3]
; GFX11NONANS-NEXT:    v_cmp_gt_f64_e32 vcc_lo, v[0:1], v[4:5]
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = fcmp ugt double %arg1, %arg3
  %cmp2 = fcmp ugt double %arg2, %arg3
  %and1  = and i1 %cmp1, %cmp2
  ret i1 %and1
}

define i1 @test59(float %arg1, float %arg2, float %arg3) #0 {
; GFX11-LABEL: test59:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_min_f32_e32 v0, v0, v1
; GFX11-NEXT:    v_cmp_nlt_f32_e32 vcc_lo, v0, v2
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test59:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_min_f32_e32 v0, v0, v1
; GFX11NONANS-NEXT:    v_cmp_ge_f32_e32 vcc_lo, v0, v2
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = fcmp uge float %arg1, %arg3
  %cmp2 = fcmp uge float %arg2, %arg3
  %and1  = and i1 %cmp1, %cmp2
  ret i1 %and1
}

define i1 @test60(float %arg1, float %arg2, float %arg3) #0 {
; GFX11-LABEL: test60:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX11-NEXT:    v_cmp_ngt_f32_e32 vcc_lo, v0, v2
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test60:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX11NONANS-NEXT:    v_cmp_le_f32_e32 vcc_lo, v0, v2
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = fcmp ule float %arg1, %arg3
  %cmp2 = fcmp ule float %arg2, %arg3
  %and1  = and i1 %cmp1, %cmp2
  ret i1 %and1
}

define i1 @test61(double %arg1, double %arg2, double %arg3) #0 {
; GFX11-LABEL: test61:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f64 v[0:1], v[0:1], v[2:3]
; GFX11-NEXT:    v_cmp_nge_f64_e32 vcc_lo, v[0:1], v[4:5]
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test61:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_max_f64 v[0:1], v[0:1], v[2:3]
; GFX11NONANS-NEXT:    v_cmp_lt_f64_e32 vcc_lo, v[0:1], v[4:5]
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = fcmp ult double %arg1, %arg3
  %cmp2 = fcmp ult double %arg2, %arg3
  %and1 = and i1 %cmp1, %cmp2
  ret i1 %and1
}

define i1 @test62(float %arg1, float %arg2, float %arg3) {
; GCN-LABEL: test62:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_dual_add_f32 v0, 1.0, v0 :: v_dual_add_f32 v1, 2.0, v1
; GCN-NEXT:    v_min_f32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_lt_f32_e32 vcc_lo, v0, v2
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %add1 = fadd nnan float %arg1, 1.0
  %add2 = fadd nnan float %arg2, 2.0
  %cmp1 = fcmp nnan olt float %add1, %arg3
  %cmp2 = fcmp nnan olt float %add2, %arg3
  %or1  = or i1 %cmp1, %cmp2
  ret i1 %or1
}

define i1 @test63(double %arg1, double %arg2, double %arg3) #0 {
; GCN-LABEL: test63:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GCN-NEXT:    v_add_f64 v[2:3], v[2:3], 2.0
; GCN-NEXT:    v_min_f64 v[0:1], v[0:1], v[2:3]
; GCN-NEXT:    v_cmp_le_f64_e32 vcc_lo, v[0:1], v[4:5]
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %add1 = fadd nnan double %arg1, 1.0
  %add2 = fadd nnan double %arg2, 2.0
  %cmp1 = fcmp nnan ole double %add1, %arg3
  %cmp2 = fcmp nnan ole double %add2, %arg3
  %or1  = or i1 %cmp1, %cmp2
  ret i1 %or1
}

define i1 @test64(double %arg1, double %arg2, double %arg3) #0 {
; GCN-LABEL: test64:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GCN-NEXT:    v_add_f64 v[2:3], v[2:3], 2.0
; GCN-NEXT:    v_max_f64 v[0:1], v[0:1], v[2:3]
; GCN-NEXT:    v_cmp_gt_f64_e32 vcc_lo, v[0:1], v[4:5]
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %add1 = fadd nnan double %arg1, 1.0
  %add2 = fadd nnan double %arg2, 2.0
  %cmp1 = fcmp nnan ogt double %add1, %arg3
  %cmp2 = fcmp nnan ogt double %add2, %arg3
  %or1  = or i1 %cmp1, %cmp2
  ret i1 %or1
}

define i1 @test65(float %arg1, float %arg2, float %arg3) {
; GCN-LABEL: test65:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_dual_add_f32 v0, 1.0, v0 :: v_dual_add_f32 v1, 2.0, v1
; GCN-NEXT:    v_max_f32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_ge_f32_e32 vcc_lo, v0, v2
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %add1 = fadd nnan float %arg1, 1.0
  %add2 = fadd nnan float %arg2, 2.0
  %cmp1 = fcmp nnan oge float %add1, %arg3
  %cmp2 = fcmp nnan oge float %add2, %arg3
  %or1  = or i1 %cmp1, %cmp2
  ret i1 %or1
}

define i1 @test66(double %arg1, double %arg2, double %arg3) {
; GCN-LABEL: test66:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GCN-NEXT:    v_add_f64 v[2:3], v[2:3], 2.0
; GCN-NEXT:    v_min_f64 v[0:1], v[0:1], v[2:3]
; GCN-NEXT:    v_cmp_gt_f64_e32 vcc_lo, v[0:1], v[4:5]
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %add1 = fadd nnan double %arg1, 1.0
  %add2 = fadd nnan double %arg2, 2.0
  %cmp1 = fcmp nnan ugt double %add1, %arg3
  %cmp2 = fcmp nnan ugt double %add2, %arg3
  %and1  = and i1 %cmp1, %cmp2
  ret i1 %and1
}

define i1 @test67(float %arg1, float %arg2, float %arg3) #0 {
; GCN-LABEL: test67:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_dual_add_f32 v0, 1.0, v0 :: v_dual_add_f32 v1, 2.0, v1
; GCN-NEXT:    v_min_f32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_ge_f32_e32 vcc_lo, v0, v2
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %add1 = fadd nnan float %arg1, 1.0
  %add2 = fadd nnan float %arg2, 2.0
  %cmp1 = fcmp nnan uge float %add1, %arg3
  %cmp2 = fcmp nnan uge float %add2, %arg3
  %and1  = and i1 %cmp1, %cmp2
  ret i1 %and1
}

define i1 @test68(float %arg1, float %arg2, float %arg3) #0 {
; GCN-LABEL: test68:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_dual_add_f32 v0, 1.0, v0 :: v_dual_add_f32 v1, 2.0, v1
; GCN-NEXT:    v_max_f32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_le_f32_e32 vcc_lo, v0, v2
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %add1 = fadd nnan float %arg1, 1.0
  %add2 = fadd nnan float %arg2, 2.0
  %cmp1 = fcmp nnan ule float %add1, %arg3
  %cmp2 = fcmp nnan ule float %add2, %arg3
  %and1  = and i1 %cmp1, %cmp2
  ret i1 %and1
}

define i1 @test69(double %arg1, double %arg2, double %arg3) {
; GCN-LABEL: test69:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GCN-NEXT:    v_add_f64 v[2:3], v[2:3], 2.0
; GCN-NEXT:    v_max_f64 v[0:1], v[0:1], v[2:3]
; GCN-NEXT:    v_cmp_lt_f64_e32 vcc_lo, v[0:1], v[4:5]
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %add1 = fadd nnan double %arg1, 1.0
  %add2 = fadd nnan double %arg2, 2.0
  %cmp1 = fcmp nnan ult double %add1, %arg3
  %cmp2 = fcmp nnan ult double %add2, %arg3
  %and1 = and i1 %cmp1, %cmp2
  ret i1 %and1
}

define i1 @test70(float %arg1, float %arg2, float %arg3) {
; GFX11-LABEL: test70:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_max_f32 v0, v0, v0 :: v_dual_max_f32 v1, v1, v1
; GFX11-NEXT:    v_min_f32_e32 v0, v0, v1
; GFX11-NEXT:    v_cmp_lt_f32_e32 vcc_lo, v0, v2
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test70:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_min_f32_e32 v0, v0, v1
; GFX11NONANS-NEXT:    v_cmp_lt_f32_e32 vcc_lo, v0, v2
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %var1 = call float @llvm.canonicalize.f32(float %arg1)
  %var2 = call float @llvm.canonicalize.f32(float %arg2)
  %cmp1 = fcmp olt float %var1, %arg3
  %cmp2 = fcmp olt float %var2, %arg3
  %or1  = or i1 %cmp1, %cmp2
  ret i1 %or1
}

define i1 @test71(double %arg1, double %arg2, double %arg3) {
; GCN-LABEL: test71:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GCN-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GCN-NEXT:    v_min_f64 v[0:1], v[0:1], v[2:3]
; GCN-NEXT:    v_cmp_le_f64_e32 vcc_lo, v[0:1], v[4:5]
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %var1 = call double @llvm.canonicalize.f64(double %arg1)
  %var2 = call double @llvm.canonicalize.f64(double %arg2)
  %cmp1 = fcmp ole double %var1, %arg3
  %cmp2 = fcmp ole double %var2, %arg3
  %or1  = or i1 %cmp1, %cmp2
  ret i1 %or1
}

define i1 @test72(double %arg1, double %arg2, double %arg3) {
; GCN-LABEL: test72:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GCN-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GCN-NEXT:    v_max_f64 v[0:1], v[0:1], v[2:3]
; GCN-NEXT:    v_cmp_gt_f64_e32 vcc_lo, v[0:1], v[4:5]
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %var1 = call double @llvm.canonicalize.f64(double %arg1)
  %var2 = call double @llvm.canonicalize.f64(double %arg2)
  %cmp1 = fcmp ogt double %var1, %arg3
  %cmp2 = fcmp ogt double %var2, %arg3
  %or1  = or i1 %cmp1, %cmp2
  ret i1 %or1
}

define i1 @test73(float %arg1, float %arg2, float %arg3) {
; GFX11-LABEL: test73:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_max_f32 v0, v0, v0 :: v_dual_max_f32 v1, v1, v1
; GFX11-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX11-NEXT:    v_cmp_ge_f32_e32 vcc_lo, v0, v2
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test73:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX11NONANS-NEXT:    v_cmp_ge_f32_e32 vcc_lo, v0, v2
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %var1 = call float @llvm.canonicalize.f32(float %arg1)
  %var2 = call float @llvm.canonicalize.f32(float %arg2)
  %cmp1 = fcmp oge float %var1, %arg3
  %cmp2 = fcmp oge float %var2, %arg3
  %or1  = or i1 %cmp1, %cmp2
  ret i1 %or1
}

define i1 @test74(double %arg1, double %arg2, double %arg3) {
; GFX11-LABEL: test74:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX11-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX11-NEXT:    v_min_f64 v[0:1], v[0:1], v[2:3]
; GFX11-NEXT:    v_cmp_nle_f64_e32 vcc_lo, v[0:1], v[4:5]
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test74:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX11NONANS-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX11NONANS-NEXT:    v_min_f64 v[0:1], v[0:1], v[2:3]
; GFX11NONANS-NEXT:    v_cmp_gt_f64_e32 vcc_lo, v[0:1], v[4:5]
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %var1 = call double @llvm.canonicalize.f64(double %arg1)
  %var2 = call double @llvm.canonicalize.f64(double %arg2)
  %cmp1 = fcmp ugt double %var1, %arg3
  %cmp2 = fcmp ugt double %var2, %arg3
  %and1  = and i1 %cmp1, %cmp2
  ret i1 %and1
}

define i1 @test75(float %arg1, float %arg2, float %arg3) {
; GFX11-LABEL: test75:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_max_f32 v0, v0, v0 :: v_dual_max_f32 v1, v1, v1
; GFX11-NEXT:    v_min_f32_e32 v0, v0, v1
; GFX11-NEXT:    v_cmp_nlt_f32_e32 vcc_lo, v0, v2
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test75:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_min_f32_e32 v0, v0, v1
; GFX11NONANS-NEXT:    v_cmp_ge_f32_e32 vcc_lo, v0, v2
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %var1 = call float @llvm.canonicalize.f32(float %arg1)
  %var2 = call float @llvm.canonicalize.f32(float %arg2)
  %cmp1 = fcmp uge float %var1, %arg3
  %cmp2 = fcmp uge float %var2, %arg3
  %and1  = and i1 %cmp1, %cmp2
  ret i1 %and1
}

define i1 @test76(float %arg1, float %arg2, float %arg3) {
; GFX11-LABEL: test76:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_max_f32 v0, v0, v0 :: v_dual_max_f32 v1, v1, v1
; GFX11-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX11-NEXT:    v_cmp_ngt_f32_e32 vcc_lo, v0, v2
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test76:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX11NONANS-NEXT:    v_cmp_le_f32_e32 vcc_lo, v0, v2
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %var1 = call float @llvm.canonicalize.f32(float %arg1)
  %var2 = call float @llvm.canonicalize.f32(float %arg2)
  %cmp1 = fcmp ule float %var1, %arg3
  %cmp2 = fcmp ule float %var2, %arg3
  %and1  = and i1 %cmp1, %cmp2
  ret i1 %and1
}

define i1 @test77(double %arg1, double %arg2, double %arg3) {
; GFX11-LABEL: test77:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX11-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX11-NEXT:    v_max_f64 v[0:1], v[0:1], v[2:3]
; GFX11-NEXT:    v_cmp_nge_f64_e32 vcc_lo, v[0:1], v[4:5]
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test77:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX11NONANS-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX11NONANS-NEXT:    v_max_f64 v[0:1], v[0:1], v[2:3]
; GFX11NONANS-NEXT:    v_cmp_lt_f64_e32 vcc_lo, v[0:1], v[4:5]
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %var1 = call double @llvm.canonicalize.f64(double %arg1)
  %var2 = call double @llvm.canonicalize.f64(double %arg2)
  %cmp1 = fcmp ult double %var1, %arg3
  %cmp2 = fcmp ult double %var2, %arg3
  %and1 = and i1 %cmp1, %cmp2
  ret i1 %and1
}

define i1 @test78(float %arg1, float %arg2, float %arg3) #0 {
; GCN-LABEL: test78:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_min_f32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_lt_f32_e32 vcc_lo, v0, v2
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = fcmp olt float %arg1, %arg3
  %cmp2 = fcmp ogt float %arg3, %arg2
  %or1  = or i1 %cmp1, %cmp2
  ret i1 %or1
}

define i1 @test79(float %arg1, float %arg2, float %arg3) #0 {
; GFX11-LABEL: test79:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX11-NEXT:    v_cmp_nge_f32_e32 vcc_lo, v0, v2
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test79:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX11NONANS-NEXT:    v_cmp_lt_f32_e32 vcc_lo, v0, v2
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = fcmp ult float %arg1, %arg3
  %cmp2 = fcmp ugt float %arg3, %arg2
  %and1  = and i1 %cmp1, %cmp2
  ret i1 %and1
}

define i1 @test80(float %arg1, float %arg2, float %arg3) {
; GCN-LABEL: test80:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_dual_add_f32 v0, 1.0, v0 :: v_dual_add_f32 v1, 2.0, v1
; GCN-NEXT:    v_max_f32_e32 v0, v0, v1
; GCN-NEXT:    v_cmp_ge_f32_e32 vcc_lo, v0, v2
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %add1 = fadd nnan float %arg1, 1.0
  %add2 = fadd nnan float %arg2, 2.0
  %cmp1 = fcmp nnan oge float %add1, %arg3
  %cmp2 = fcmp nnan ole float %arg3, %add2
  %or1  = or i1 %cmp1, %cmp2
  ret i1 %or1
}

define i1 @test81(double %arg1, double %arg2, double %arg3) {
; GCN-LABEL: test81:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GCN-NEXT:    v_add_f64 v[2:3], v[2:3], 2.0
; GCN-NEXT:    v_min_f64 v[0:1], v[0:1], v[2:3]
; GCN-NEXT:    v_cmp_gt_f64_e32 vcc_lo, v[0:1], v[4:5]
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %add1 = fadd nnan double %arg1, 1.0
  %add2 = fadd nnan double %arg2, 2.0
  %cmp1 = fcmp nnan ugt double %add1, %arg3
  %cmp2 = fcmp nnan ult double %arg3, %add2
  %and1  = and i1 %cmp1, %cmp2
  ret i1 %and1
}

define i1 @test82(double %arg1, double %arg2, double %arg3) {
; GCN-LABEL: test82:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GCN-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GCN-NEXT:    v_min_f64 v[0:1], v[0:1], v[2:3]
; GCN-NEXT:    v_cmp_le_f64_e32 vcc_lo, v[0:1], v[4:5]
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %var1 = call double @llvm.canonicalize.f64(double %arg1)
  %var2 = call double @llvm.canonicalize.f64(double %arg2)
  %cmp1 = fcmp ole double %var1, %arg3
  %cmp2 = fcmp oge double %arg3, %var2
  %or1  = or i1 %cmp1, %cmp2
  ret i1 %or1
}

define i1 @test83(float %arg1, float %arg2, float %arg3) {
; GFX11-LABEL: test83:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_max_f32 v0, v0, v0 :: v_dual_max_f32 v1, v1, v1
; GFX11-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX11-NEXT:    v_cmp_ngt_f32_e32 vcc_lo, v0, v2
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test83:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX11NONANS-NEXT:    v_cmp_le_f32_e32 vcc_lo, v0, v2
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %var1 = call float @llvm.canonicalize.f32(float %arg1)
  %var2 = call float @llvm.canonicalize.f32(float %arg2)
  %cmp1 = fcmp ule float %var1, %arg3
  %cmp2 = fcmp uge float %arg3, %var2
  %and1  = and i1 %cmp1, %cmp2
  ret i1 %and1
}

define i1 @test84(half %arg1, half %arg2, half %arg3) {
; GFX11-LABEL: test84:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f16_e32 v0, v0, v0
; GFX11-NEXT:    v_max_f16_e32 v1, v1, v1
; GFX11-NEXT:    v_min_f16_e32 v0, v0, v1
; GFX11-NEXT:    v_cmp_lt_f16_e32 vcc_lo, v0, v2
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test84:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_min_f16_e32 v0, v0, v1
; GFX11NONANS-NEXT:    v_cmp_lt_f16_e32 vcc_lo, v0, v2
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %var1 = call half @llvm.canonicalize.f16(half %arg1)
  %var2 = call half @llvm.canonicalize.f16(half %arg2)
  %cmp1 = fcmp olt half %var1, %arg3
  %cmp2 = fcmp olt half %var2, %arg3
  %or1  = or i1 %cmp1, %cmp2
  ret i1 %or1
}

define <2 x i1> @test85(<2 x half> %arg1, <2 x half> %arg2, <2 x half> %arg3) {
; GFX11-LABEL: test85:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_pk_max_f16 v0, v0, v0
; GFX11-NEXT:    v_pk_max_f16 v1, v1, v1
; GFX11-NEXT:    v_pk_min_f16 v0, v0, v1
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX11-NEXT:    v_cmp_le_f16_e32 vcc_lo, v0, v2
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11-NEXT:    v_cmp_le_f16_e32 vcc_lo, v3, v1
; GFX11-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test85:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_pk_min_f16 v0, v0, v1
; GFX11NONANS-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; GFX11NONANS-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX11NONANS-NEXT:    v_cmp_le_f16_e32 vcc_lo, v0, v2
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    v_cmp_le_f16_e32 vcc_lo, v3, v1
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %var1 = call <2 x half> @llvm.canonicalize.v2f16(<2 x half> %arg1)
  %var2 = call <2 x half> @llvm.canonicalize.v2f16(<2 x half> %arg2)
  %cmp1 = fcmp ole <2 x half> %var1, %arg3
  %cmp2 = fcmp ole <2 x half> %var2, %arg3
  %or1  = or <2 x i1> %cmp1, %cmp2
  ret <2 x i1> %or1
}

define <2 x i1> @test86(<2 x half> %arg1, <2 x half> %arg2, <2 x half> %arg3) {
; GFX11-LABEL: test86:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_pk_max_f16 v0, v0, v0
; GFX11-NEXT:    v_pk_max_f16 v1, v1, v1
; GFX11-NEXT:    v_pk_max_f16 v0, v0, v1
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX11-NEXT:    v_cmp_gt_f16_e32 vcc_lo, v0, v2
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11-NEXT:    v_cmp_gt_f16_e32 vcc_lo, v3, v1
; GFX11-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test86:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_pk_max_f16 v0, v0, v1
; GFX11NONANS-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; GFX11NONANS-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX11NONANS-NEXT:    v_cmp_gt_f16_e32 vcc_lo, v0, v2
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    v_cmp_gt_f16_e32 vcc_lo, v3, v1
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %var1 = call <2 x half> @llvm.canonicalize.v2f16(<2 x half> %arg1)
  %var2 = call <2 x half> @llvm.canonicalize.v2f16(<2 x half> %arg2)
  %cmp1 = fcmp ogt <2 x half> %var1, %arg3
  %cmp2 = fcmp ogt <2 x half> %var2, %arg3
  %or1  = or <2 x i1> %cmp1, %cmp2
  ret <2 x i1> %or1
}

define i1 @test87(half %arg1, half %arg2, half %arg3) {
; GFX11-LABEL: test87:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f16_e32 v0, v0, v0
; GFX11-NEXT:    v_max_f16_e32 v1, v1, v1
; GFX11-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX11-NEXT:    v_cmp_ge_f16_e32 vcc_lo, v0, v2
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test87:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX11NONANS-NEXT:    v_cmp_ge_f16_e32 vcc_lo, v0, v2
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %var1 = call half @llvm.canonicalize.f16(half %arg1)
  %var2 = call half @llvm.canonicalize.f16(half %arg2)
  %cmp1 = fcmp oge half %var1, %arg3
  %cmp2 = fcmp oge half %var2, %arg3
  %or1  = or i1 %cmp1, %cmp2
  ret i1 %or1
}

define <2 x i1> @test88(<2 x half> %arg1, <2 x half> %arg2, <2 x half> %arg3) {
; GFX11-LABEL: test88:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_pk_max_f16 v0, v0, v0
; GFX11-NEXT:    v_pk_max_f16 v1, v1, v1
; GFX11-NEXT:    v_pk_min_f16 v0, v0, v1
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX11-NEXT:    v_cmp_nle_f16_e32 vcc_lo, v0, v2
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11-NEXT:    v_cmp_nle_f16_e32 vcc_lo, v3, v1
; GFX11-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test88:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_pk_min_f16 v0, v0, v1
; GFX11NONANS-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; GFX11NONANS-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX11NONANS-NEXT:    v_cmp_gt_f16_e32 vcc_lo, v0, v2
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    v_cmp_gt_f16_e32 vcc_lo, v3, v1
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %var1 = call <2 x half> @llvm.canonicalize.v2f16(<2 x half> %arg1)
  %var2 = call <2 x half> @llvm.canonicalize.v2f16(<2 x half> %arg2)
  %cmp1 = fcmp ugt <2 x half> %var1, %arg3
  %cmp2 = fcmp ugt <2 x half> %var2, %arg3
  %and1  = and <2 x i1> %cmp1, %cmp2
  ret <2 x i1> %and1
}

define i1 @test89(half %arg1, half %arg2, half %arg3) {
; GFX11-LABEL: test89:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f16_e32 v0, v0, v0
; GFX11-NEXT:    v_max_f16_e32 v1, v1, v1
; GFX11-NEXT:    v_min_f16_e32 v0, v0, v1
; GFX11-NEXT:    v_cmp_nlt_f16_e32 vcc_lo, v0, v2
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test89:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_min_f16_e32 v0, v0, v1
; GFX11NONANS-NEXT:    v_cmp_ge_f16_e32 vcc_lo, v0, v2
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %var1 = call half @llvm.canonicalize.f16(half %arg1)
  %var2 = call half @llvm.canonicalize.f16(half %arg2)
  %cmp1 = fcmp uge half %var1, %arg3
  %cmp2 = fcmp uge half %var2, %arg3
  %and1  = and i1 %cmp1, %cmp2
  ret i1 %and1
}

define i1 @test90(half %arg1, half %arg2, half %arg3) {
; GFX11-LABEL: test90:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f16_e32 v0, v0, v0
; GFX11-NEXT:    v_max_f16_e32 v1, v1, v1
; GFX11-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX11-NEXT:    v_cmp_ngt_f16_e32 vcc_lo, v0, v2
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test90:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_max_f16_e32 v0, v0, v1
; GFX11NONANS-NEXT:    v_cmp_le_f16_e32 vcc_lo, v0, v2
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %var1 = call half @llvm.canonicalize.f16(half %arg1)
  %var2 = call half @llvm.canonicalize.f16(half %arg2)
  %cmp1 = fcmp ule half %var1, %arg3
  %cmp2 = fcmp ule half %var2, %arg3
  %and1  = and i1 %cmp1, %cmp2
  ret i1 %and1
}

define <2 x i1> @test91(<2 x half> %arg1, <2 x half> %arg2, <2 x half> %arg3) {
; GFX11-LABEL: test91:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_pk_max_f16 v0, v0, v0
; GFX11-NEXT:    v_pk_max_f16 v1, v1, v1
; GFX11-NEXT:    v_pk_max_f16 v0, v0, v1
; GFX11-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX11-NEXT:    v_cmp_nge_f16_e32 vcc_lo, v0, v2
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11-NEXT:    v_cmp_nge_f16_e32 vcc_lo, v3, v1
; GFX11-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test91:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_pk_max_f16 v0, v0, v1
; GFX11NONANS-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; GFX11NONANS-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX11NONANS-NEXT:    v_cmp_lt_f16_e32 vcc_lo, v0, v2
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    v_cmp_lt_f16_e32 vcc_lo, v3, v1
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v1, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %var1 = call <2 x half> @llvm.canonicalize.v2f16(<2 x half> %arg1)
  %var2 = call <2 x half> @llvm.canonicalize.v2f16(<2 x half> %arg2)
  %cmp1 = fcmp ult <2 x half> %var1, %arg3
  %cmp2 = fcmp ult <2 x half> %var2, %arg3
  %and1 = and <2 x i1> %cmp1, %cmp2
  ret <2 x i1> %and1
}

define i1 @test92(i32 %arg1, i32 %arg2, i32 %arg3, i32 %C) {
; GCN-LABEL: test92:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_min3_u32 v0, v0, v1, v2
; GCN-NEXT:    v_cmp_lt_u32_e32 vcc_lo, v0, v3
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp ult i32 %arg1, %C
  %cmp2 = icmp ult i32 %arg2, %C
  %cmp3 = icmp ult i32 %arg3, %C
  %or1 = or i1 %cmp1, %cmp2
  %or2 = or i1 %or1, %cmp3
  ret i1 %or2
}

define i1 @test93(i32 %arg1, i32 %arg2, i32 %arg3, i32 %arg4, i32 %C) {
; GCN-LABEL: test93:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_min_u32_e32 v0, v0, v1
; GCN-NEXT:    v_max_u32_e32 v1, v2, v3
; GCN-NEXT:    v_cmp_lt_u32_e32 vcc_lo, v0, v4
; GCN-NEXT:    v_cmp_gt_u32_e64 s0, v1, v4
; GCN-NEXT:    s_or_b32 s0, vcc_lo, s0
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp ult i32 %arg1, %C
  %cmp2 = icmp ult i32 %arg2, %C
  %cmp3 = icmp ugt i32 %arg3, %C
  %cmp4 = icmp ugt i32 %arg4, %C
  %or1 = or i1 %cmp1, %cmp2
  %or2 = or i1 %cmp3, %cmp4
  %or3 = or i1 %or1, %or2
  ret i1 %or3
}

define i1 @test94(i32 %arg1, i32 %arg2, i32 %arg3, i32 %arg4, i32 %arg5, i32 %arg6, i32 %arg7, i32 %arg8, i32 %C) {
; GCN-LABEL: test94:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_min_u32_e32 v2, v2, v3
; GCN-NEXT:    v_min3_u32 v0, v0, v1, v2
; GCN-NEXT:    v_min_u32_e32 v0, v0, v4
; GCN-NEXT:    v_min3_u32 v0, v5, v6, v0
; GCN-NEXT:    v_cmp_lt_u32_e32 vcc_lo, v0, v8
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp ult i32 %arg1, %C
  %cmp2 = icmp ult i32 %arg2, %C
  %or1  = or i1 %cmp1, %cmp2
  %cmp3 = icmp ult i32 %arg3, %C
  %cmp4 = icmp ult i32 %arg4, %C
  %or2  = or i1 %cmp3, %cmp4
  %cmp5 = icmp ult i32 %arg5, %C
  %or3 = or i1 %or1, %or2
  %or4 = or i1 %or3, %cmp5
  %cmp6 = icmp ult i32 %arg6, %C
  %cmp7 = icmp ult i32 %arg7, %C
  %or5 = or i1 %cmp6, %cmp7
  %cmp8 = icmp ult i32 %arg8, %C
  %or6 = or i1 %or5, %or4
  %or7 = or i1 %or6, %cmp8
  ret i1 %or6
}

define i1 @test95(i32 %arg1, i32 %arg2, i32 %arg3, i32 %arg4, i32 %C) {
; GCN-LABEL: test95:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_maxmin_u32 v0, v0, v1, v2
; GCN-NEXT:    v_cmp_lt_u32_e32 vcc_lo, v0, v4
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp ult i32 %arg1, %C
  %cmp2 = icmp ult i32 %arg2, %C
  %cmp3 = icmp ult i32 %arg3, %C
  %and1 = and i1 %cmp1, %cmp2
  %or1 = or i1 %and1, %cmp3
  ret i1 %or1
}

define i1 @test96(i32 %arg1, i32 %arg2, i32 %arg3, i32 %arg4, i32 %C) {
; GCN-LABEL: test96:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_minmax_u32 v0, v0, v1, v2
; GCN-NEXT:    v_cmp_lt_u32_e32 vcc_lo, v0, v4
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp ult i32 %arg1, %C
  %cmp2 = icmp ult i32 %arg2, %C
  %cmp3 = icmp ult i32 %arg3, %C
  %and1 = or i1 %cmp1, %cmp2
  %or1 = and i1 %and1, %cmp3
  ret i1 %or1
}

define i1 @test97(i32 %arg1, i32 %arg2, i32 %arg3, i32 %arg4, i32 %C) {
; GCN-LABEL: test97:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_min_u32_e32 v0, v0, v1
; GCN-NEXT:    v_max3_u32 v0, v0, v2, v3
; GCN-NEXT:    v_cmp_lt_u32_e32 vcc_lo, v0, v4
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp ult i32 %arg1, %C
  %cmp2 = icmp ult i32 %arg2, %C
  %cmp3 = icmp ult i32 %arg3, %C
  %cmp4 = icmp ult i32 %arg4, %C
  %or1 = or i1 %cmp1, %cmp2
  %and1 = and i1 %cmp3, %cmp4
  %and2 = and i1 %or1, %and1
  ret i1 %and2
}

define i1 @test98(i32 %arg1, i32 %arg2, i32 %arg3, i32 %arg4, i32 %C) {
; GCN-LABEL: test98:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_min_u32_e32 v2, v2, v3
; GCN-NEXT:    v_minmax_u32 v0, v0, v1, v2
; GCN-NEXT:    v_cmp_lt_u32_e32 vcc_lo, v0, v4
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp ult i32 %arg1, %C
  %cmp2 = icmp ult i32 %arg2, %C
  %cmp3 = icmp ult i32 %arg3, %C
  %cmp4 = icmp ult i32 %arg4, %C
  %or1 = or i1 %cmp1, %cmp2
  %or2 = or i1 %cmp3, %cmp4
  %and1 = and i1 %or1, %or2
  ret i1 %and1
}

define i1 @test99(i32 %arg1, i32 %arg2, i32 %arg3, i32 %arg4, i32 %C) {
; GCN-LABEL: test99:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_max_u32_e32 v2, v2, v3
; GCN-NEXT:    v_min3_u32 v0, v0, v1, v2
; GCN-NEXT:    v_cmp_lt_u32_e32 vcc_lo, v0, v4
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp ult i32 %arg1, %C
  %cmp2 = icmp ult i32 %arg2, %C
  %cmp3 = icmp ult i32 %arg3, %C
  %cmp4 = icmp ult i32 %arg4, %C
  %or1 = or i1 %cmp1, %cmp2
  %and1 = and i1 %cmp3, %cmp4
  %or2 = or i1 %or1, %and1
  ret i1 %or2
}

define i1 @test100(i32 %arg1, i32 %arg2, i32 %arg3, i32 %arg4, i32 %C) {
; GCN-LABEL: test100:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_max_u32_e32 v2, v2, v3
; GCN-NEXT:    v_maxmin_u32 v0, v0, v1, v2
; GCN-NEXT:    v_cmp_lt_u32_e32 vcc_lo, v0, v4
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp ult i32 %arg1, %C
  %cmp2 = icmp ult i32 %arg2, %C
  %cmp3 = icmp ult i32 %arg3, %C
  %cmp4 = icmp ult i32 %arg4, %C
  %and1 = and i1 %cmp1, %cmp2
  %and2 = and i1 %cmp3, %cmp4
  %or1 = or i1 %and1, %and2
  ret i1 %or1
}

define i1 @test101(i32 %arg1, i32 %arg2, i32 %arg3, i32 %arg4, i32 %arg5, i32 %arg6, i32 %C) {
; GCN-LABEL: test101:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_max_u32_e32 v0, v0, v1
; GCN-NEXT:    v_minmax_u32 v1, v3, v4, v5
; GCN-NEXT:    v_min3_u32 v0, v0, v2, v1
; GCN-NEXT:    v_cmp_lt_u32_e32 vcc_lo, v0, v6
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp ult i32 %arg1, %C
  %cmp2 = icmp ult i32 %arg2, %C
  %cmp3 = icmp ult i32 %arg3, %C
  %and1 = and i1 %cmp1, %cmp2
  %or1 = or i1 %and1, %cmp3
  %cmp4 = icmp ult i32 %arg4, %C
  %cmp5 = icmp ult i32 %arg5, %C
  %cmp6 = icmp ult i32 %arg6, %C
  %or2 = or i1 %cmp4, %cmp5
  %and2 = and i1 %or2, %cmp6
  %or3 = or i1 %or1, %and2
  ret i1 %or3
}

define i1 @test102(i32 %arg1, i32 %arg2, i32 %arg3, i32 %arg4, i32 %arg5, i32 %arg6, i32 %C) {
; GCN-LABEL: test102:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_max_u32_e32 v0, v0, v1
; GCN-NEXT:    v_min_u32_e32 v1, v2, v3
; GCN-NEXT:    v_min3_u32 v0, v0, v5, v1
; GCN-NEXT:    v_cmp_lt_u32_e32 vcc_lo, v0, v6
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp ult i32 %arg1, %C
  %cmp2 = icmp ult i32 %arg2, %C
  %cmp3 = icmp ult i32 %arg3, %C
  %cmp4 = icmp ult i32 %arg4, %C
  %cmp5 = icmp ult i32 %arg5, %C
  %cmp6 = icmp ult i32 %arg6, %C
  %and1 = and i1 %cmp1, %cmp2
  %or1 = or i1 %cmp3, %cmp4
  %and2 = and i1 %cmp4, %cmp5
  %or2 = or i1 %and1, %cmp6
  %or3 = or i1 %or1, %and2
  %or4 = or i1 %or2, %or3
  ret i1 %or4
}

define i1 @test103(i32 %arg1, i32 %arg2, i32 %arg3, i32 %arg4, i32 %arg5, i32 %arg6, i32 %C) {
; GCN-LABEL: test103:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_max_u32_e32 v4, v4, v5
; GCN-NEXT:    v_max_u32_e32 v2, v2, v3
; GCN-NEXT:    v_maxmin_u32 v0, v0, v1, v4
; GCN-NEXT:    v_cmp_gt_u32_e32 vcc_lo, v2, v6
; GCN-NEXT:    v_cmp_lt_u32_e64 s0, v0, v6
; GCN-NEXT:    s_or_b32 s0, s0, vcc_lo
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp ult i32 %arg1, %C
  %cmp2 = icmp ult i32 %arg2, %C
  %cmp3 = icmp ugt i32 %arg3, %C
  %cmp4 = icmp ugt i32 %arg4, %C
  %cmp5 = icmp ult i32 %arg5, %C
  %cmp6 = icmp ult i32 %arg6, %C
  %and1 = and i1 %cmp1, %cmp2
  %or1 = or i1 %cmp3, %cmp4
  %and2 = and i1 %cmp5, %cmp6
  %or2 = or i1 %and1, %or1
  %or3 = or i1 %or2, %and2
  ret i1 %or3
}


define i1 @test104(i32 %arg1, i32 %arg2, i32 %arg3, i32 %arg4, i32 %arg5, i32 %arg6, i32 %arg7, i32 %arg8, i32 %arg9, i32 %arg10, i32 %C) {
; GCN-LABEL: test104:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_min_u32_e32 v8, v8, v9
; GCN-NEXT:    v_max_u32_e32 v2, v2, v3
; GCN-NEXT:    v_min_u32_e32 v3, v4, v5
; GCN-NEXT:    v_max_u32_e32 v4, v6, v7
; GCN-NEXT:    v_min3_u32 v0, v0, v1, v8
; GCN-NEXT:    v_cmp_gt_u32_e32 vcc_lo, v2, v10
; GCN-NEXT:    v_cmp_lt_u32_e64 s0, v3, v10
; GCN-NEXT:    v_cmp_gt_u32_e64 s1, v4, v10
; GCN-NEXT:    v_cmp_lt_u32_e64 s2, v0, v10
; GCN-NEXT:    s_or_b32 s0, s0, s1
; GCN-NEXT:    s_or_b32 s1, s2, vcc_lo
; GCN-NEXT:    s_or_b32 s0, s0, s1
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp ult i32 %arg1, %C
  %cmp2 = icmp ult i32 %arg2, %C
  %cmp3 = icmp ugt i32 %arg3, %C
  %cmp4 = icmp ugt i32 %arg4, %C
  %cmp5 = icmp ult i32 %arg5, %C
  %cmp6 = icmp ult i32 %arg6, %C
  %cmp7 = icmp ugt i32 %arg7, %C
  %cmp8 = icmp ugt i32 %arg8, %C
  %cmp9 = icmp ult i32 %arg9, %C
  %cmp10 = icmp ult i32 %arg10, %C
  %or1 = or i1 %cmp1, %cmp2
  %or2 = or i1 %cmp3, %cmp4
  %or3 = or i1 %cmp5, %cmp6
  %or4 = or i1 %cmp7, %cmp8
  %or5 = or i1 %cmp9, %cmp10
  %or6 = or i1 %or1, %or2
  %or7 = or i1 %or3, %or4
  %or8 = or i1 %or5, %or6
  %or9 = or i1 %or7, %or8
  ret i1 %or9
}

define i1 @test105(i32 %arg1, i32 %arg2, i32 %arg3, i32 %arg4, i32 %arg5, i32 %arg6, i32 %arg7, i32 %arg8, i32 %arg9, i32 %arg10, i32 %C) {
; GCN-LABEL: test105:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_max_u32_e32 v0, v0, v1
; GCN-NEXT:    v_max_u32_e32 v1, v2, v3
; GCN-NEXT:    v_max_u32_e32 v2, v4, v5
; GCN-NEXT:    v_max_u32_e32 v3, v6, v7
; GCN-NEXT:    v_cmp_lt_u32_e32 vcc_lo, v0, v10
; GCN-NEXT:    v_cmp_gt_u32_e64 s0, v1, v10
; GCN-NEXT:    v_cmp_lt_u32_e64 s1, v2, v10
; GCN-NEXT:    v_cmp_gt_u32_e64 s2, v3, v10
; GCN-NEXT:    s_and_b32 s0, vcc_lo, s0
; GCN-NEXT:    s_or_b32 s1, s2, s1
; GCN-NEXT:    s_and_b32 s0, s0, s1
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp ult i32 %arg1, %C
  %cmp2 = icmp ult i32 %arg2, %C
  %cmp3 = icmp ugt i32 %arg3, %C
  %cmp4 = icmp ugt i32 %arg4, %C
  %cmp5 = icmp ult i32 %arg5, %C
  %cmp6 = icmp ult i32 %arg6, %C
  %cmp7 = icmp ugt i32 %arg7, %C
  %cmp8 = icmp ugt i32 %arg8, %C
  %and1 = and i1 %cmp1, %cmp2
  %or1 = or i1 %cmp3, %cmp4
  %and2 = and i1 %cmp5, %cmp6
  %or2 = or i1 %cmp7, %cmp8
  %and3 = and i1 %and1, %or1
  %or3 = or i1 %or2, %and2
  %or4 = and i1 %and3, %or3
  ret i1 %or4
}

define i1 @test106(i32 %arg1, i32 %arg2, i32 %arg3, i32 %arg4, i32 %arg5, i32 %arg6, i32 %arg7, i32 %arg8, i32 %arg9, i32 %arg10, i32 %arg11, i32 %arg12, i32 %C1, i32 %C2) {
; GCN-LABEL: test106:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_min_u32_e32 v6, v6, v7
; GCN-NEXT:    v_min_u32_e32 v0, v0, v1
; GCN-NEXT:    v_min_u32_e32 v1, v10, v11
; GCN-NEXT:    v_min_u32_e32 v2, v2, v3
; GCN-NEXT:    v_min3_u32 v3, v4, v5, v6
; GCN-NEXT:    v_cmp_lt_u32_e32 vcc_lo, v0, v12
; GCN-NEXT:    v_min3_u32 v0, v8, v9, v1
; GCN-NEXT:    v_cmp_lt_u32_e64 s0, v2, v13
; GCN-NEXT:    v_cmp_lt_u32_e64 s1, v3, v13
; GCN-NEXT:    v_cmp_lt_u32_e64 s2, v0, v12
; GCN-NEXT:    s_or_b32 s0, vcc_lo, s0
; GCN-NEXT:    s_or_b32 s0, s0, s1
; GCN-NEXT:    s_or_b32 s0, s2, s0
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp ult i32 %arg1, %C1
  %cmp2 = icmp ult i32 %arg2, %C1
  %cmp3 = icmp ult i32 %arg3, %C2
  %cmp4 = icmp ult i32 %arg4, %C2
  %cmp5 = icmp ult i32 %arg5, %C2
  %cmp6 = icmp ult i32 %arg6, %C2
  %cmp7 = icmp ult i32 %arg7, %C2
  %cmp8 = icmp ult i32 %arg8, %C2
  %cmp9 = icmp ult i32 %arg9, %C1
  %cmp10 = icmp ult i32 %arg10, %C1
  %cmp11 = icmp ult i32 %arg11, %C1
  %cmp12 = icmp ult i32 %arg12, %C1
  %or1 = or i1 %cmp1, %cmp2
  %or2 = or i1 %cmp3, %cmp4
  %or3 = or i1 %cmp5, %cmp6
  %or4 = or i1 %cmp7, %cmp8
  %or5 = or i1 %cmp9, %cmp10
  %or6 = or i1 %cmp11, %cmp12
  %or7 = or i1 %or1, %or2
  %or8 = or i1 %or3, %or4
  %or9 = or i1 %or5, %or6
  %or10 = or i1 %or7, %or8
  %or11 = or i1 %or9, %or10
  ret i1 %or11
}

define i1 @test107(float %arg1, float %arg2, float %arg3, float %C) {
; GCN-LABEL: test107:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_min3_f32 v0, v0, v1, v2
; GCN-NEXT:    v_cmp_lt_f32_e32 vcc_lo, v0, v3
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = fcmp olt float %arg1, %C
  %cmp2 = fcmp olt float %arg2, %C
  %cmp3 = fcmp olt float %arg3, %C
  %or1 = or i1 %cmp1, %cmp2
  %or2 = or i1 %or1, %cmp3
  ret i1 %or2
}

define i1 @test108(float %arg1, float %arg2, float %arg3, float %C) {
; GFX11-LABEL: test108:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max3_f32 v0, v0, v1, v2
; GFX11-NEXT:    v_cmp_nge_f32_e32 vcc_lo, v0, v3
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test108:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_max3_f32 v0, v0, v1, v2
; GFX11NONANS-NEXT:    v_cmp_lt_f32_e32 vcc_lo, v0, v3
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = fcmp ult float %arg1, %C
  %cmp2 = fcmp ult float %arg2, %C
  %cmp3 = fcmp ult float %arg3, %C
  %and1 = and i1 %cmp1, %cmp2
  %and2 = and i1 %and1, %cmp3
  ret i1 %and2
}

define i1 @test109(float %arg1, float %arg2, float %arg3, float %arg4, float %C) {
; GFX11-LABEL: test109:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_max_f32 v1, v1, v1 :: v_dual_max_f32 v0, v0, v0
; GFX11-NEXT:    v_dual_max_f32 v3, v3, v3 :: v_dual_max_f32 v2, v2, v2
; GFX11-NEXT:    v_dual_min_f32 v0, v0, v1 :: v_dual_max_f32 v1, v2, v3
; GFX11-NEXT:    v_cmp_lt_f32_e32 vcc_lo, v0, v4
; GFX11-NEXT:    v_cmp_gt_f32_e64 s0, v1, v4
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test109:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_dual_min_f32 v0, v0, v1 :: v_dual_max_f32 v1, v2, v3
; GFX11NONANS-NEXT:    v_cmp_lt_f32_e32 vcc_lo, v0, v4
; GFX11NONANS-NEXT:    v_cmp_gt_f32_e64 s0, v1, v4
; GFX11NONANS-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = fcmp olt float %arg1, %C
  %cmp2 = fcmp olt float %arg2, %C
  %cmp3 = fcmp ogt float %arg3, %C
  %cmp4 = fcmp ogt float %arg4, %C
  %or1 = or i1 %cmp1, %cmp2
  %or2 = or i1 %cmp3, %cmp4
  %or3 = or i1 %or1, %or2
  ret i1 %or3
}

define i1 @test110(float %arg1, float %arg2, float %arg3, float %arg4, float %C1, float %C2, float %C3, float %C4, float %C) #0 {
; GCN-LABEL: test110:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_dual_add_f32 v0, v0, v4 :: v_dual_add_f32 v1, v1, v5
; GCN-NEXT:    v_dual_add_f32 v2, v2, v6 :: v_dual_add_f32 v3, v3, v7
; GCN-NEXT:    v_dual_max_f32 v0, v0, v1 :: v_dual_min_f32 v1, v2, v3
; GCN-NEXT:    v_cmp_lt_f32_e32 vcc_lo, v0, v8
; GCN-NEXT:    v_cmp_gt_f32_e64 s0, v1, v8
; GCN-NEXT:    s_and_b32 s0, vcc_lo, s0
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %add1 = fadd nnan float %arg1, %C1
  %add2 = fadd nnan float %arg2, %C2
  %add3 = fadd nnan float %arg3, %C3
  %add4 = fadd nnan float %arg4, %C4
  %cmp1 = fcmp nnan ult float %add1, %C
  %cmp2 = fcmp nnan ult float %add2, %C
  %cmp3 = fcmp nnan ugt float %add3, %C
  %cmp4 = fcmp nnan ugt float %add4, %C
  %or1 = and i1 %cmp1, %cmp2
  %or2 = and i1 %cmp3, %cmp4
  %or3 = and i1 %or1, %or2
  ret i1 %or3
}

define i1 @test111(float %arg1, float %arg2, float %arg3, float %arg4, float %arg5, float %arg6, float %arg7, float %arg8, float %C) {
; GFX11-LABEL: test111:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_max_f32 v3, v3, v3 :: v_dual_max_f32 v2, v2, v2
; GFX11-NEXT:    v_dual_min_f32 v2, v2, v3 :: v_dual_max_f32 v3, v4, v4
; GFX11-NEXT:    v_min3_f32 v0, v0, v1, v2
; GFX11-NEXT:    v_min_f32_e32 v0, v0, v3
; GFX11-NEXT:    v_min3_f32 v0, v5, v6, v0
; GFX11-NEXT:    v_cmp_lt_f32_e32 vcc_lo, v0, v8
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test111:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_min_f32_e32 v2, v2, v3
; GFX11NONANS-NEXT:    v_min3_f32 v0, v0, v1, v2
; GFX11NONANS-NEXT:    v_min_f32_e32 v0, v0, v4
; GFX11NONANS-NEXT:    v_min3_f32 v0, v5, v6, v0
; GFX11NONANS-NEXT:    v_cmp_lt_f32_e32 vcc_lo, v0, v8
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = fcmp olt float %arg1, %C
  %cmp2 = fcmp olt float %arg2, %C
  %or1  = or i1 %cmp1, %cmp2
  %cmp3 = fcmp olt float %arg3, %C
  %cmp4 = fcmp olt float %arg4, %C
  %or2  = or i1 %cmp3, %cmp4
  %cmp5 = fcmp olt float %arg5, %C
  %or3 = or i1 %or1, %or2
  %or4 = or i1 %or3, %cmp5
  %cmp6 = fcmp olt float %arg6, %C
  %cmp7 = fcmp olt float %arg7, %C
  %or5 = or i1 %cmp6, %cmp7
  %cmp8 = fcmp olt float %arg8, %C
  %or6 = or i1 %or5, %or4
  %or7 = or i1 %or6, %cmp8
  ret i1 %or6
}

define i1 @test112(float %arg1, float %arg2, float %arg3, float %arg4, float %arg5, float %arg6, float %arg7, float %arg8, float %C) {
; GFX11-LABEL: test112:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_max_f32 v3, v3, v3 :: v_dual_max_f32 v2, v2, v2
; GFX11-NEXT:    v_cmp_nge_f32_e32 vcc_lo, v4, v8
; GFX11-NEXT:    v_dual_max_f32 v5, v5, v5 :: v_dual_min_f32 v2, v2, v3
; GFX11-NEXT:    v_max_f32_e32 v3, v6, v6
; GFX11-NEXT:    v_min3_f32 v0, v0, v1, v2
; GFX11-NEXT:    v_min3_f32 v0, v0, v5, v3
; GFX11-NEXT:    v_cmp_lt_f32_e64 s0, v0, v8
; GFX11-NEXT:    s_or_b32 s0, s0, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test112:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_min_f32_e32 v2, v2, v3
; GFX11NONANS-NEXT:    v_min3_f32 v0, v0, v1, v2
; GFX11NONANS-NEXT:    v_min_f32_e32 v0, v0, v4
; GFX11NONANS-NEXT:    v_min3_f32 v0, v5, v6, v0
; GFX11NONANS-NEXT:    v_cmp_lt_f32_e32 vcc_lo, v0, v8
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = fcmp olt float %arg1, %C
  %cmp2 = fcmp olt float %arg2, %C
  %or1  = or i1 %cmp1, %cmp2
  %cmp3 = fcmp olt float %arg3, %C
  %cmp4 = fcmp olt float %arg4, %C
  %or2  = or i1 %cmp3, %cmp4
  %cmp5 = fcmp ult float %arg5, %C
  %or3 = or i1 %or1, %or2
  %or4 = or i1 %or3, %cmp5
  %cmp6 = fcmp olt float %arg6, %C
  %cmp7 = fcmp olt float %arg7, %C
  %or5 = or i1 %cmp6, %cmp7
  %cmp8 = fcmp ult float %arg8, %C
  %or6 = or i1 %or5, %or4
  %or7 = or i1 %or6, %cmp8
  ret i1 %or6
}

define i1 @test113(float %arg1, float %arg2, float %arg3, float %C) {
; GFX11-LABEL: test113:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_max_f32 v1, v1, v1 :: v_dual_max_f32 v0, v0, v0
; GFX11-NEXT:    v_cmp_lt_f32_e32 vcc_lo, v2, v3
; GFX11-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX11-NEXT:    v_cmp_nge_f32_e64 s0, v0, v3
; GFX11-NEXT:    s_or_b32 s0, s0, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test113:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_maxmin_f32 v0, v0, v1, v2
; GFX11NONANS-NEXT:    v_cmp_lt_f32_e32 vcc_lo, v0, v3
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = fcmp ult float %arg1, %C
  %cmp2 = fcmp ult float %arg2, %C
  %cmp3 = fcmp olt float %arg3, %C
  %and1 = and i1 %cmp1, %cmp2
  %or1 = or i1 %and1, %cmp3
  ret i1 %or1
}

define i1 @test114(float %arg1, float %arg2, float %arg3, float %C) {
; GFX11-LABEL: test114:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_max_f32 v1, v1, v1 :: v_dual_max_f32 v0, v0, v0
; GFX11-NEXT:    v_cmp_nge_f32_e32 vcc_lo, v2, v3
; GFX11-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX11-NEXT:    v_cmp_gt_f32_e64 s0, v0, v3
; GFX11-NEXT:    s_and_b32 s0, s0, vcc_lo
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test114:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX11NONANS-NEXT:    v_cmp_lt_f32_e32 vcc_lo, v2, v3
; GFX11NONANS-NEXT:    v_cmp_gt_f32_e64 s0, v0, v3
; GFX11NONANS-NEXT:    s_and_b32 s0, s0, vcc_lo
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = fcmp ogt float %arg1, %C
  %cmp2 = fcmp ogt float %arg2, %C
  %cmp3 = fcmp ult float %arg3, %C
  %and1 = or i1 %cmp1, %cmp2
  %or1 = and i1 %and1, %cmp3
  ret i1 %or1
}

define i1 @test115(float %arg1, float %arg2, float %arg3, float %arg4, float %C) {
; GFX11-LABEL: test115:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_max_f32 v2, v2, v2 :: v_dual_max_f32 v1, v1, v1
; GFX11-NEXT:    v_dual_max_f32 v0, v0, v0 :: v_dual_max_f32 v3, v3, v3
; GFX11-NEXT:    v_dual_min_f32 v0, v0, v1 :: v_dual_max_f32 v1, v2, v3
; GFX11-NEXT:    v_cmp_lt_f32_e32 vcc_lo, v0, v4
; GFX11-NEXT:    v_cmp_nge_f32_e64 s0, v1, v4
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test115:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_max_f32_e32 v2, v2, v3
; GFX11NONANS-NEXT:    v_min3_f32 v0, v0, v1, v2
; GFX11NONANS-NEXT:    v_cmp_lt_f32_e32 vcc_lo, v0, v4
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = fcmp olt float %arg1, %C
  %cmp2 = fcmp olt float %arg2, %C
  %var3 = call float @llvm.canonicalize.f32(float %arg3)
  %var4 = call float @llvm.canonicalize.f32(float %arg4)
  %cmp3 = fcmp ult float %var3, %C
  %cmp4 = fcmp ult float %var4, %C
  %or1 = or i1 %cmp1, %cmp2
  %and1 = and i1 %cmp3, %cmp4
  %or2 = or i1 %or1, %and1
  ret i1 %or2
}

define i1 @test116(float %arg1, float %arg2, float %arg3, float %arg4, float %arg5, float %arg6, float %arg7, float %arg8, float %arg9, float %arg10, float %C) {
; GFX11-LABEL: test116:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_max_f32 v9, v9, v9 :: v_dual_max_f32 v8, v8, v8
; GFX11-NEXT:    v_dual_max_f32 v1, v1, v1 :: v_dual_max_f32 v0, v0, v0
; GFX11-NEXT:    v_dual_max_f32 v3, v3, v3 :: v_dual_max_f32 v2, v2, v2
; GFX11-NEXT:    v_dual_max_f32 v5, v5, v5 :: v_dual_max_f32 v4, v4, v4
; GFX11-NEXT:    v_dual_max_f32 v7, v7, v7 :: v_dual_max_f32 v6, v6, v6
; GFX11-NEXT:    v_min_f32_e32 v8, v8, v9
; GFX11-NEXT:    v_dual_max_f32 v2, v2, v3 :: v_dual_min_f32 v3, v4, v5
; GFX11-NEXT:    v_max_f32_e32 v4, v6, v7
; GFX11-NEXT:    v_min3_f32 v0, v0, v1, v8
; GFX11-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v2, v10
; GFX11-NEXT:    v_cmp_lt_f32_e64 s0, v3, v10
; GFX11-NEXT:    v_cmp_gt_f32_e64 s1, v4, v10
; GFX11-NEXT:    v_cmp_lt_f32_e64 s2, v0, v10
; GFX11-NEXT:    s_or_b32 s0, s0, s1
; GFX11-NEXT:    s_or_b32 s1, s2, vcc_lo
; GFX11-NEXT:    s_or_b32 s0, s0, s1
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test116:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_min_f32_e32 v8, v8, v9
; GFX11NONANS-NEXT:    v_dual_max_f32 v2, v2, v3 :: v_dual_min_f32 v3, v4, v5
; GFX11NONANS-NEXT:    v_max_f32_e32 v4, v6, v7
; GFX11NONANS-NEXT:    v_min3_f32 v0, v0, v1, v8
; GFX11NONANS-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v2, v10
; GFX11NONANS-NEXT:    v_cmp_lt_f32_e64 s0, v3, v10
; GFX11NONANS-NEXT:    v_cmp_gt_f32_e64 s1, v4, v10
; GFX11NONANS-NEXT:    v_cmp_lt_f32_e64 s2, v0, v10
; GFX11NONANS-NEXT:    s_or_b32 s0, s0, s1
; GFX11NONANS-NEXT:    s_or_b32 s1, s2, vcc_lo
; GFX11NONANS-NEXT:    s_or_b32 s0, s0, s1
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = fcmp olt float %arg1, %C
  %cmp2 = fcmp olt float %arg2, %C
  %cmp3 = fcmp ogt float %arg3, %C
  %cmp4 = fcmp ogt float %arg4, %C
  %cmp5 = fcmp olt float %arg5, %C
  %cmp6 = fcmp olt float %arg6, %C
  %cmp7 = fcmp ogt float %arg7, %C
  %cmp8 = fcmp ogt float %arg8, %C
  %cmp9 = fcmp olt float %arg9, %C
  %cmp10 = fcmp olt float %arg10, %C
  %or1 = or i1 %cmp1, %cmp2
  %or2 = or i1 %cmp3, %cmp4
  %or3 = or i1 %cmp5, %cmp6
  %or4 = or i1 %cmp7, %cmp8
  %or5 = or i1 %cmp9, %cmp10
  %or6 = or i1 %or1, %or2
  %or7 = or i1 %or3, %or4
  %or8 = or i1 %or5, %or6
  %or9 = or i1 %or7, %or8
  ret i1 %or9
}

define i1 @test117(float %arg1, float %arg2, float %arg3, float %arg4, float %arg5, float %arg6, float %arg7, float %arg8, float %arg9, float %arg10, float %arg11, float %arg12, float %C1, float %C2) {
; GFX11-LABEL: test117:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_max_f32 v3, v3, v3 :: v_dual_max_f32 v6, v6, v6
; GFX11-NEXT:    v_dual_max_f32 v7, v7, v7 :: v_dual_max_f32 v10, v10, v10
; GFX11-NEXT:    v_dual_max_f32 v1, v1, v1 :: v_dual_max_f32 v0, v0, v0
; GFX11-NEXT:    v_dual_max_f32 v11, v11, v11 :: v_dual_max_f32 v2, v2, v2
; GFX11-NEXT:    v_min_f32_e32 v6, v6, v7
; GFX11-NEXT:    v_dual_min_f32 v0, v0, v1 :: v_dual_min_f32 v1, v10, v11
; GFX11-NEXT:    v_min_f32_e32 v2, v2, v3
; GFX11-NEXT:    v_min3_f32 v3, v4, v5, v6
; GFX11-NEXT:    v_cmp_lt_f32_e32 vcc_lo, v0, v12
; GFX11-NEXT:    v_min3_f32 v0, v8, v9, v1
; GFX11-NEXT:    v_cmp_lt_f32_e64 s0, v2, v13
; GFX11-NEXT:    v_cmp_lt_f32_e64 s1, v3, v13
; GFX11-NEXT:    v_cmp_lt_f32_e64 s2, v0, v12
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    s_or_b32 s0, s0, s1
; GFX11-NEXT:    s_or_b32 s0, s2, s0
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test117:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_min_f32_e32 v6, v6, v7
; GFX11NONANS-NEXT:    v_dual_min_f32 v0, v0, v1 :: v_dual_min_f32 v1, v10, v11
; GFX11NONANS-NEXT:    v_min_f32_e32 v2, v2, v3
; GFX11NONANS-NEXT:    v_min3_f32 v3, v4, v5, v6
; GFX11NONANS-NEXT:    v_cmp_lt_f32_e32 vcc_lo, v0, v12
; GFX11NONANS-NEXT:    v_min3_f32 v0, v8, v9, v1
; GFX11NONANS-NEXT:    v_cmp_lt_f32_e64 s0, v2, v13
; GFX11NONANS-NEXT:    v_cmp_lt_f32_e64 s1, v3, v13
; GFX11NONANS-NEXT:    v_cmp_lt_f32_e64 s2, v0, v12
; GFX11NONANS-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11NONANS-NEXT:    s_or_b32 s0, s0, s1
; GFX11NONANS-NEXT:    s_or_b32 s0, s2, s0
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = fcmp olt float %arg1, %C1
  %cmp2 = fcmp olt float %arg2, %C1
  %cmp3 = fcmp olt float %arg3, %C2
  %cmp4 = fcmp olt float %arg4, %C2
  %cmp5 = fcmp olt float %arg5, %C2
  %cmp6 = fcmp olt float %arg6, %C2
  %cmp7 = fcmp olt float %arg7, %C2
  %cmp8 = fcmp olt float %arg8, %C2
  %cmp9 = fcmp olt float %arg9, %C1
  %cmp10 = fcmp olt float %arg10, %C1
  %cmp11 = fcmp olt float %arg11, %C1
  %cmp12 = fcmp olt float %arg12, %C1
  %or1 = or i1 %cmp1, %cmp2
  %or2 = or i1 %cmp3, %cmp4
  %or3 = or i1 %cmp5, %cmp6
  %or4 = or i1 %cmp7, %cmp8
  %or5 = or i1 %cmp9, %cmp10
  %or6 = or i1 %cmp11, %cmp12
  %or7 = or i1 %or1, %or2
  %or8 = or i1 %or3, %or4
  %or9 = or i1 %or5, %or6
  %or10 = or i1 %or7, %or8
  %or11 = or i1 %or9, %or10
  ret i1 %or11
}


define i1 @test118(float %arg1, float %arg2, float %arg3, float %arg4, float %C1, float %C2, float %C3, float %C4, float %C) #0 {
; GCN-LABEL: test118:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_dual_add_f32 v0, v0, v4 :: v_dual_add_f32 v1, v1, v5
; GCN-NEXT:    v_dual_add_f32 v2, v2, v6 :: v_dual_add_f32 v3, v3, v7
; GCN-NEXT:    v_min_f32_e32 v0, v0, v1
; GCN-NEXT:    v_max3_f32 v0, v0, v2, v3
; GCN-NEXT:    v_cmp_lt_f32_e32 vcc_lo, v0, v8
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %add1 = fadd nnan float %arg1, %C1
  %add2 = fadd nnan float %arg2, %C2
  %add3 = fadd nnan float %arg3, %C3
  %add4 = fadd nnan float %arg4, %C4
  %cmp1 = fcmp nnan ult float %add1, %C
  %cmp2 = fcmp nnan ult float %add2, %C
  %cmp3 = fcmp nnan ult float %add3, %C
  %cmp4 = fcmp nnan ult float %add4, %C
  %or1 = or i1 %cmp1, %cmp2
  %and1 = and i1 %cmp3, %cmp4
  %and2 = and i1 %or1, %and1
  ret i1 %and2
}

define i1 @test119(float %arg1, float %arg2, float %arg3, float %arg4, float %C1, float %C2, float %C3, float %C4, float %C) #0 {
; GCN-LABEL: test119:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_dual_add_f32 v2, v2, v6 :: v_dual_add_f32 v3, v3, v7
; GCN-NEXT:    v_dual_add_f32 v0, v0, v4 :: v_dual_add_f32 v1, v1, v5
; GCN-NEXT:    v_min_f32_e32 v2, v2, v3
; GCN-NEXT:    v_minmax_f32 v0, v0, v1, v2
; GCN-NEXT:    v_cmp_lt_f32_e32 vcc_lo, v0, v8
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %add1 = fadd nnan float %arg1, %C1
  %add2 = fadd nnan float %arg2, %C2
  %add3 = fadd nnan float %arg3, %C3
  %add4 = fadd nnan float %arg4, %C4
  %cmp1 = fcmp nnan ult float %add1, %C
  %cmp2 = fcmp nnan ult float %add2, %C
  %cmp3 = fcmp nnan ult float %add3, %C
  %cmp4 = fcmp nnan ult float %add4, %C
  %or1 = or i1 %cmp1, %cmp2
  %and1 = or i1 %cmp3, %cmp4
  %and2 = and i1 %or1, %and1
  ret i1 %and2
}

define i1 @test120(float %arg1, float %arg2, float %arg3, float %arg4, float %C1, float %C2, float %C3, float %C4, float %C) #0 {
; GCN-LABEL: test120:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_dual_add_f32 v2, v2, v6 :: v_dual_add_f32 v3, v3, v7
; GCN-NEXT:    v_dual_add_f32 v0, v0, v4 :: v_dual_add_f32 v1, v1, v5
; GCN-NEXT:    v_max_f32_e32 v2, v2, v3
; GCN-NEXT:    v_min3_f32 v0, v0, v1, v2
; GCN-NEXT:    v_cmp_lt_f32_e32 vcc_lo, v0, v8
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %add1 = fadd nnan float %arg1, %C1
  %add2 = fadd nnan float %arg2, %C2
  %add3 = fadd nnan float %arg3, %C3
  %add4 = fadd nnan float %arg4, %C4
  %cmp1 = fcmp nnan ult float %add1, %C
  %cmp2 = fcmp nnan ult float %add2, %C
  %cmp3 = fcmp nnan ult float %add3, %C
  %cmp4 = fcmp nnan ult float %add4, %C
  %or1 = or i1 %cmp1, %cmp2
  %and1 = and i1 %cmp3, %cmp4
  %and2 = or i1 %or1, %and1
  ret i1 %and2
}

define i1 @test121(float %arg1, float %arg2, float %arg3, float %arg4, float %C1, float %C2, float %C3, float %C4, float %C) #0 {
; GCN-LABEL: test121:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_dual_add_f32 v2, v2, v6 :: v_dual_add_f32 v3, v3, v7
; GCN-NEXT:    v_dual_add_f32 v0, v0, v4 :: v_dual_add_f32 v1, v1, v5
; GCN-NEXT:    v_max_f32_e32 v2, v2, v3
; GCN-NEXT:    v_maxmin_f32 v0, v0, v1, v2
; GCN-NEXT:    v_cmp_lt_f32_e32 vcc_lo, v0, v8
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %add1 = fadd nnan float %arg1, %C1
  %add2 = fadd nnan float %arg2, %C2
  %add3 = fadd nnan float %arg3, %C3
  %add4 = fadd nnan float %arg4, %C4
  %cmp1 = fcmp nnan ult float %add1, %C
  %cmp2 = fcmp nnan ult float %add2, %C
  %cmp3 = fcmp nnan ult float %add3, %C
  %cmp4 = fcmp nnan ult float %add4, %C
  %or1 = and i1 %cmp1, %cmp2
  %and1 = and i1 %cmp3, %cmp4
  %and2 = or i1 %or1, %and1
  ret i1 %and2
}

define i1 @test122(double %arg1, double %arg2, double %arg3) #1 {
; GCN-LABEL: test122:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_min_f64 v[0:1], v[0:1], v[2:3]
; GCN-NEXT:    v_cmp_lt_f64_e32 vcc_lo, v[0:1], v[4:5]
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = fcmp ult double %arg1, %arg3
  %cmp2 = fcmp ult double %arg2, %arg3
  %or1 = or i1 %cmp1, %cmp2
  ret i1 %or1
}

define i1 @test123(double %arg1, double %arg2, double %arg3) #1 {
; GCN-LABEL: test123:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GCN-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GCN-NEXT:    v_min_f64 v[0:1], v[0:1], v[2:3]
; GCN-NEXT:    v_cmp_gt_f64_e32 vcc_lo, v[0:1], v[4:5]
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %var1 = call double @llvm.canonicalize.f64(double %arg1)
  %var2 = call double @llvm.canonicalize.f64(double %arg2)
  %cmp1 = fcmp ogt double %var1, %arg3
  %cmp2 = fcmp ogt double %var2, %arg3
  %or1 = and i1 %cmp1, %cmp2
 ret i1 %or1
}

; The optimization does not apply to the following tests.

define i1 @test124(i32 %arg1, i64 %arg2) {
; GCN-LABEL: test124:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cmp_gt_i64_e32 vcc_lo, 0x3e8, v[1:2]
; GCN-NEXT:    v_cmp_gt_i32_e64 s0, 0x3e8, v0
; GCN-NEXT:    s_or_b32 s0, s0, vcc_lo
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp slt i32 %arg1, 1000
  %cmp2 = icmp slt i64 %arg2, 1000
  %or  = or i1 %cmp1, %cmp2
  ret i1 %or
}

define i1 @test125(i32 %arg1, i32 %arg2) {
; GCN-LABEL: test125:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc_lo, 0x3e8, v0
; GCN-NEXT:    v_cmp_eq_u32_e64 s0, 0x3e8, v1
; GCN-NEXT:    s_or_b32 s0, vcc_lo, s0
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp eq i32 %arg1, 1000
  %cmp2 = icmp eq i32 %arg2, 1000
  %or  = or i1 %cmp1, %cmp2
  ret i1 %or
}

define i1 @test126(i32 %arg1, i32 %arg2) {
; GCN-LABEL: test126:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0x3e8, v0
; GCN-NEXT:    v_cmp_ne_u32_e64 s0, 0x3e8, v1
; GCN-NEXT:    s_or_b32 s0, vcc_lo, s0
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp ne i32 %arg1, 1000
  %cmp2 = icmp ne i32 %arg2, 1000
  %or  = or i1 %cmp1, %cmp2
  ret i1 %or
}

define i1 @test127(i64 %arg1, i64 %arg2, i64 %arg3) {
; GCN-LABEL: test127:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cmp_lt_u64_e32 vcc_lo, v[0:1], v[4:5]
; GCN-NEXT:    v_cmp_lt_u64_e64 s0, v[2:3], v[4:5]
; GCN-NEXT:    s_or_b32 s0, vcc_lo, s0
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GCN-NEXT:    s_setpc_b64 s[30:31]
   %cmp1 = icmp ult i64 %arg1, %arg3
   %cmp2 = icmp ult i64 %arg2, %arg3
   %or = or i1 %cmp1, %cmp2
   ret i1 %or
}

define i1 @test128(i32 %arg1, i32 %arg2, i32 %arg3) {
; GCN-LABEL: test128:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cmp_lt_u32_e32 vcc_lo, v0, v2
; GCN-NEXT:    v_cmp_lt_u32_e64 s0, v2, v1
; GCN-NEXT:    s_or_b32 s0, vcc_lo, s0
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp ult i32 %arg1, %arg3
  %cmp2 = icmp ult i32 %arg3, %arg2
  %or = or i1 %cmp1, %cmp2
  ret i1 %or
}

define i1 @test129(i32 %arg1, i32 %arg2, i32 %arg3) {
; GCN-LABEL: test129:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cmp_lt_u32_e32 vcc_lo, v0, v2
; GCN-NEXT:    v_cmp_le_u32_e64 s0, v1, v2
; GCN-NEXT:    s_or_b32 s0, vcc_lo, s0
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp ult i32 %arg1, %arg3
  %cmp2 = icmp ule i32 %arg2, %arg3
  %or = or i1 %cmp1, %cmp2
  ret i1 %or
}

define i1 @test130(i32 %arg1, i32 %arg2, i32 %arg3) {
; GCN-LABEL: test130:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cmp_le_u32_e32 vcc_lo, v2, v0
; GCN-NEXT:    v_cmp_gt_u32_e64 s0, v1, v2
; GCN-NEXT:    s_or_b32 s0, vcc_lo, s0
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp ule i32 %arg3, %arg1
  %cmp2 = icmp ugt i32 %arg2, %arg3
  %or = or i1 %cmp1, %cmp2
  ret i1 %or
}

define i1 @test131(i16 %arg1, i32 %arg2) {
; GCN-LABEL: test131:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cmp_gt_u16_e32 vcc_lo, 10, v0
; GCN-NEXT:    v_cmp_gt_u32_e64 s0, 10, v1
; GCN-NEXT:    s_or_b32 s0, vcc_lo, s0
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp ult i16 %arg1, 10
  %cmp2 = icmp ult i32 %arg2, 10
  %or = or i1 %cmp1, %cmp2
  ret i1 %or
}

define i1 @test132(i32 %arg1, i32 %arg2, i32 %arg3, i32 %arg4) {
; GCN-LABEL: test132:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cmp_lt_u32_e32 vcc_lo, v0, v2
; GCN-NEXT:    v_cmp_lt_u32_e64 s0, v1, v2
; GCN-NEXT:    v_cmp_lt_u32_e64 s1, v0, v3
; GCN-NEXT:    s_or_b32 s0, vcc_lo, s0
; GCN-NEXT:    s_or_b32 s1, s1, vcc_lo
; GCN-NEXT:    s_or_b32 s0, s0, s1
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp ult i32 %arg1, %arg3
  %cmp2 = icmp ult i32 %arg2, %arg3
  %or1 = or i1 %cmp1, %cmp2
  %cmp3 = icmp ult i32 %arg1, %arg4
  %or2 = or i1 %cmp3, %cmp1
  %or3 = or i1 %or1, %or2
  ret i1 %or3
}

define i1 @test133(i32 %arg1, i32 %arg2) {
; GCN-LABEL: test133:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cmp_gt_u32_e32 vcc_lo, 0x64, v0
; GCN-NEXT:    v_cmp_gt_u32_e64 s0, 0x3e8, v1
; GCN-NEXT:    s_or_b32 s0, vcc_lo, s0
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = icmp ult i32 %arg1, 100
  %cmp2 = icmp ult i32 %arg2, 1000
  %or = or i1 %cmp1, %cmp2
  ret i1 %or
}

define i1 @test134(float %arg1, float %arg2, float %arg3) #0 {
; GFX11-LABEL: test134:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_lt_f32_e32 vcc_lo, v0, v2
; GFX11-NEXT:    v_cmp_gt_f32_e64 s0, v2, v1
; GFX11-NEXT:    s_and_b32 s0, vcc_lo, s0
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test134:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX11NONANS-NEXT:    v_cmp_lt_f32_e32 vcc_lo, v0, v2
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = fcmp olt float %arg1, %arg3
  %cmp2 = fcmp ogt float %arg3, %arg2
  %and1  = and i1 %cmp1, %cmp2
  ret i1 %and1
}

define i1 @test135(float %arg1, float %arg2, float %arg3) #0 {
; GFX11-LABEL: test135:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_nge_f32_e32 vcc_lo, v0, v2
; GFX11-NEXT:    v_cmp_nle_f32_e64 s0, v2, v1
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test135:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_min_f32_e32 v0, v0, v1
; GFX11NONANS-NEXT:    v_cmp_lt_f32_e32 vcc_lo, v0, v2
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = fcmp ult float %arg1, %arg3
  %cmp2 = fcmp ugt float %arg3, %arg2
  %or1  = or i1 %cmp1, %cmp2
  ret i1 %or1
}

define i1 @test136(double %arg1, double %arg2, double %arg3) {
; GFX11-LABEL: test136:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX11-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX11-NEXT:    v_cmp_le_f64_e32 vcc_lo, v[0:1], v[4:5]
; GFX11-NEXT:    v_cmp_ge_f64_e64 s0, v[4:5], v[2:3]
; GFX11-NEXT:    s_and_b32 s0, vcc_lo, s0
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test136:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX11NONANS-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX11NONANS-NEXT:    v_max_f64 v[0:1], v[0:1], v[2:3]
; GFX11NONANS-NEXT:    v_cmp_le_f64_e32 vcc_lo, v[0:1], v[4:5]
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %var1 = call double @llvm.canonicalize.f64(double %arg1)
  %var2 = call double @llvm.canonicalize.f64(double %arg2)
  %cmp1 = fcmp ole double %var1, %arg3
  %cmp2 = fcmp oge double %arg3, %var2
  %and1  = and i1 %cmp1, %cmp2
  ret i1 %and1
}

define i1 @test137(float %arg1, float %arg2, float %arg3) {
; GFX11-LABEL: test137:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_max_f32 v0, v0, v0 :: v_dual_max_f32 v1, v1, v1
; GFX11-NEXT:    v_cmp_ngt_f32_e32 vcc_lo, v0, v2
; GFX11-NEXT:    v_cmp_nlt_f32_e64 s0, v2, v1
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test137:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_min_f32_e32 v0, v0, v1
; GFX11NONANS-NEXT:    v_cmp_le_f32_e32 vcc_lo, v0, v2
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %var1 = call float @llvm.canonicalize.f32(float %arg1)
  %var2 = call float @llvm.canonicalize.f32(float %arg2)
  %cmp1 = fcmp ule float %var1, %arg3
  %cmp2 = fcmp uge float %arg3, %var2
  %or1  = or i1 %cmp1, %cmp2
  ret i1 %or1
}

define i1 @test138(float %arg1, float %arg2, float %arg3) #0 {
; GFX11-LABEL: test138:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_lt_f32_e32 vcc_lo, v0, v2
; GFX11-NEXT:    v_cmp_lt_f32_e64 s0, v1, v2
; GFX11-NEXT:    s_and_b32 s0, vcc_lo, s0
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test138:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX11NONANS-NEXT:    v_cmp_lt_f32_e32 vcc_lo, v0, v2
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = fcmp olt float %arg1, %arg3
  %cmp2 = fcmp olt float %arg2, %arg3
  %and1  = and i1 %cmp1, %cmp2
  ret i1 %and1
}

define i1 @test139(double %arg1, double %arg2, double %arg3) #0 {
; GFX11-LABEL: test139:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_le_f64_e32 vcc_lo, v[0:1], v[4:5]
; GFX11-NEXT:    v_cmp_le_f64_e64 s0, v[2:3], v[4:5]
; GFX11-NEXT:    s_and_b32 s0, vcc_lo, s0
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test139:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_max_f64 v[0:1], v[0:1], v[2:3]
; GFX11NONANS-NEXT:    v_cmp_le_f64_e32 vcc_lo, v[0:1], v[4:5]
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = fcmp ole double %arg1, %arg3
  %cmp2 = fcmp ole double %arg2, %arg3
  %and1  = and i1 %cmp1, %cmp2
  ret i1 %and1
}

define i1 @test140(double %arg1, double %arg2, double %arg3) #0 {
; GFX11-LABEL: test140:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_gt_f64_e32 vcc_lo, v[0:1], v[4:5]
; GFX11-NEXT:    v_cmp_gt_f64_e64 s0, v[2:3], v[4:5]
; GFX11-NEXT:    s_and_b32 s0, vcc_lo, s0
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test140:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_min_f64 v[0:1], v[0:1], v[2:3]
; GFX11NONANS-NEXT:    v_cmp_gt_f64_e32 vcc_lo, v[0:1], v[4:5]
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = fcmp ogt double %arg1, %arg3
  %cmp2 = fcmp ogt double %arg2, %arg3
  %and1  = and i1 %cmp1, %cmp2
  ret i1 %and1
}

define i1 @test141(float %arg1, float %arg2, float %arg3) #0 {
; GFX11-LABEL: test141:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_ge_f32_e32 vcc_lo, v0, v2
; GFX11-NEXT:    v_cmp_ge_f32_e64 s0, v1, v2
; GFX11-NEXT:    s_and_b32 s0, vcc_lo, s0
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test141:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_min_f32_e32 v0, v0, v1
; GFX11NONANS-NEXT:    v_cmp_ge_f32_e32 vcc_lo, v0, v2
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = fcmp oge float %arg1, %arg3
  %cmp2 = fcmp oge float %arg2, %arg3
  %and1  = and i1 %cmp1, %cmp2
  ret i1 %and1
}

define i1 @test142(double %arg1, double %arg2, double %arg3) #0 {
; GFX11-LABEL: test142:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_nle_f64_e32 vcc_lo, v[0:1], v[4:5]
; GFX11-NEXT:    v_cmp_nle_f64_e64 s0, v[2:3], v[4:5]
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test142:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_max_f64 v[0:1], v[0:1], v[2:3]
; GFX11NONANS-NEXT:    v_cmp_gt_f64_e32 vcc_lo, v[0:1], v[4:5]
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = fcmp ugt double %arg1, %arg3
  %cmp2 = fcmp ugt double %arg2, %arg3
  %or1  = or i1 %cmp1, %cmp2
  ret i1 %or1
}

define i1 @test143(float %arg1, float %arg2, float %arg3) #0 {
; GFX11-LABEL: test143:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_nlt_f32_e32 vcc_lo, v0, v2
; GFX11-NEXT:    v_cmp_nlt_f32_e64 s0, v1, v2
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test143:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX11NONANS-NEXT:    v_cmp_ge_f32_e32 vcc_lo, v0, v2
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = fcmp uge float %arg1, %arg3
  %cmp2 = fcmp uge float %arg2, %arg3
  %or1  = or i1 %cmp1, %cmp2
  ret i1 %or1
}

define i1 @test144(float %arg1, float %arg2, float %arg3) #0 {
; GFX11-LABEL: test144:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_ngt_f32_e32 vcc_lo, v0, v2
; GFX11-NEXT:    v_cmp_ngt_f32_e64 s0, v1, v2
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test144:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_min_f32_e32 v0, v0, v1
; GFX11NONANS-NEXT:    v_cmp_le_f32_e32 vcc_lo, v0, v2
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = fcmp ule float %arg1, %arg3
  %cmp2 = fcmp ule float %arg2, %arg3
  %or1  = or i1 %cmp1, %cmp2
  ret i1 %or1
}

define i1 @test145(double %arg1, double %arg2, double %arg3) #0 {
; GFX11-LABEL: test145:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_nge_f64_e32 vcc_lo, v[0:1], v[4:5]
; GFX11-NEXT:    v_cmp_nge_f64_e64 s0, v[2:3], v[4:5]
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test145:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_min_f64 v[0:1], v[0:1], v[2:3]
; GFX11NONANS-NEXT:    v_cmp_lt_f64_e32 vcc_lo, v[0:1], v[4:5]
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %cmp1 = fcmp ult double %arg1, %arg3
  %cmp2 = fcmp ult double %arg2, %arg3
  %or1 = or i1 %cmp1, %cmp2
  ret i1 %or1
}

define i1 @test146(float %arg1, float %arg2, float %arg3) {
; GFX11-LABEL: test146:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_max_f32 v0, v0, v0 :: v_dual_max_f32 v1, v1, v1
; GFX11-NEXT:    v_cmp_lt_f32_e32 vcc_lo, v0, v2
; GFX11-NEXT:    v_cmp_lt_f32_e64 s0, v1, v2
; GFX11-NEXT:    s_and_b32 s0, vcc_lo, s0
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test146:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX11NONANS-NEXT:    v_cmp_lt_f32_e32 vcc_lo, v0, v2
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %var1 = call float @llvm.canonicalize.f32(float %arg1)
  %var2 = call float @llvm.canonicalize.f32(float %arg2)
  %cmp1 = fcmp olt float %var1, %arg3
  %cmp2 = fcmp olt float %var2, %arg3
  %and1  = and i1 %cmp1, %cmp2
  ret i1 %and1
}

define i1 @test147(double %arg1, double %arg2, double %arg3) {
; GFX11-LABEL: test147:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX11-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX11-NEXT:    v_cmp_le_f64_e32 vcc_lo, v[0:1], v[4:5]
; GFX11-NEXT:    v_cmp_le_f64_e64 s0, v[2:3], v[4:5]
; GFX11-NEXT:    s_and_b32 s0, vcc_lo, s0
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test147:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX11NONANS-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX11NONANS-NEXT:    v_max_f64 v[0:1], v[0:1], v[2:3]
; GFX11NONANS-NEXT:    v_cmp_le_f64_e32 vcc_lo, v[0:1], v[4:5]
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %var1 = call double @llvm.canonicalize.f64(double %arg1)
  %var2 = call double @llvm.canonicalize.f64(double %arg2)
  %cmp1 = fcmp ole double %var1, %arg3
  %cmp2 = fcmp ole double %var2, %arg3
  %and1  = and i1 %cmp1, %cmp2
  ret i1 %and1
}

define i1 @test148(double %arg1, double %arg2, double %arg3) {
; GFX11-LABEL: test148:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX11-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX11-NEXT:    v_cmp_gt_f64_e32 vcc_lo, v[0:1], v[4:5]
; GFX11-NEXT:    v_cmp_gt_f64_e64 s0, v[2:3], v[4:5]
; GFX11-NEXT:    s_and_b32 s0, vcc_lo, s0
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test148:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX11NONANS-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX11NONANS-NEXT:    v_min_f64 v[0:1], v[0:1], v[2:3]
; GFX11NONANS-NEXT:    v_cmp_gt_f64_e32 vcc_lo, v[0:1], v[4:5]
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %var1 = call double @llvm.canonicalize.f64(double %arg1)
  %var2 = call double @llvm.canonicalize.f64(double %arg2)
  %cmp1 = fcmp ogt double %var1, %arg3
  %cmp2 = fcmp ogt double %var2, %arg3
  %and1  = and i1 %cmp1, %cmp2
  ret i1 %and1
}

define i1 @test149(float %arg1, float %arg2, float %arg3) {
; GFX11-LABEL: test149:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_max_f32 v0, v0, v0 :: v_dual_max_f32 v1, v1, v1
; GFX11-NEXT:    v_cmp_ge_f32_e32 vcc_lo, v0, v2
; GFX11-NEXT:    v_cmp_ge_f32_e64 s0, v1, v2
; GFX11-NEXT:    s_and_b32 s0, vcc_lo, s0
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test149:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_min_f32_e32 v0, v0, v1
; GFX11NONANS-NEXT:    v_cmp_ge_f32_e32 vcc_lo, v0, v2
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %var1 = call float @llvm.canonicalize.f32(float %arg1)
  %var2 = call float @llvm.canonicalize.f32(float %arg2)
  %cmp1 = fcmp oge float %var1, %arg3
  %cmp2 = fcmp oge float %var2, %arg3
  %and1  = and i1 %cmp1, %cmp2
  ret i1 %and1
}

define i1 @test150(double %arg1, double %arg2, double %arg3) {
; GFX11-LABEL: test150:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX11-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX11-NEXT:    v_cmp_nle_f64_e32 vcc_lo, v[0:1], v[4:5]
; GFX11-NEXT:    v_cmp_nle_f64_e64 s0, v[2:3], v[4:5]
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test150:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX11NONANS-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX11NONANS-NEXT:    v_max_f64 v[0:1], v[0:1], v[2:3]
; GFX11NONANS-NEXT:    v_cmp_gt_f64_e32 vcc_lo, v[0:1], v[4:5]
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %var1 = call double @llvm.canonicalize.f64(double %arg1)
  %var2 = call double @llvm.canonicalize.f64(double %arg2)
  %cmp1 = fcmp ugt double %var1, %arg3
  %cmp2 = fcmp ugt double %var2, %arg3
  %or1  = or i1 %cmp1, %cmp2
  ret i1 %or1
}

define i1 @test151(float %arg1, float %arg2, float %arg3) {
; GFX11-LABEL: test151:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_max_f32 v0, v0, v0 :: v_dual_max_f32 v1, v1, v1
; GFX11-NEXT:    v_cmp_nlt_f32_e32 vcc_lo, v0, v2
; GFX11-NEXT:    v_cmp_nlt_f32_e64 s0, v1, v2
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test151:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX11NONANS-NEXT:    v_cmp_ge_f32_e32 vcc_lo, v0, v2
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %var1 = call float @llvm.canonicalize.f32(float %arg1)
  %var2 = call float @llvm.canonicalize.f32(float %arg2)
  %cmp1 = fcmp uge float %var1, %arg3
  %cmp2 = fcmp uge float %var2, %arg3
  %or1  = or i1 %cmp1, %cmp2
  ret i1 %or1
}

define i1 @test152(float %arg1, float %arg2, float %arg3) {
; GFX11-LABEL: test152:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_max_f32 v0, v0, v0 :: v_dual_max_f32 v1, v1, v1
; GFX11-NEXT:    v_cmp_ngt_f32_e32 vcc_lo, v0, v2
; GFX11-NEXT:    v_cmp_ngt_f32_e64 s0, v1, v2
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test152:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_min_f32_e32 v0, v0, v1
; GFX11NONANS-NEXT:    v_cmp_le_f32_e32 vcc_lo, v0, v2
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %var1 = call float @llvm.canonicalize.f32(float %arg1)
  %var2 = call float @llvm.canonicalize.f32(float %arg2)
  %cmp1 = fcmp ule float %var1, %arg3
  %cmp2 = fcmp ule float %var2, %arg3
  %or1  = or i1 %cmp1, %cmp2
  ret i1 %or1
}

define i1 @test153(double %arg1, double %arg2, double %arg3) {
; GFX11-LABEL: test153:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX11-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX11-NEXT:    v_cmp_nge_f64_e32 vcc_lo, v[0:1], v[4:5]
; GFX11-NEXT:    v_cmp_nge_f64_e64 s0, v[2:3], v[4:5]
; GFX11-NEXT:    s_or_b32 s0, vcc_lo, s0
; GFX11-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11NONANS-LABEL: test153:
; GFX11NONANS:       ; %bb.0:
; GFX11NONANS-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11NONANS-NEXT:    v_max_f64 v[0:1], v[0:1], v[0:1]
; GFX11NONANS-NEXT:    v_max_f64 v[2:3], v[2:3], v[2:3]
; GFX11NONANS-NEXT:    v_min_f64 v[0:1], v[0:1], v[2:3]
; GFX11NONANS-NEXT:    v_cmp_lt_f64_e32 vcc_lo, v[0:1], v[4:5]
; GFX11NONANS-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc_lo
; GFX11NONANS-NEXT:    s_setpc_b64 s[30:31]
  %var1 = call double @llvm.canonicalize.f64(double %arg1)
  %var2 = call double @llvm.canonicalize.f64(double %arg2)
  %cmp1 = fcmp ult double %var1, %arg3
  %cmp2 = fcmp ult double %var2, %arg3
  %or1 = or i1 %cmp1, %cmp2
  ret i1 %or1
}

declare double @llvm.canonicalize.f64(double)
declare float @llvm.canonicalize.f32(float)
declare half @llvm.canonicalize.f16(half)
declare <2 x half> @llvm.canonicalize.v2f16(<2 x half>)

attributes #0 = { nounwind "amdgpu-ieee"="false" }
attributes #1 = { nounwind "unsafe-fp-math"="true" "no-nans-fp-math"="true" }
